"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, web_acl_id: str, resource_type: str = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic Regional documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of resources associated with the specified web ACL.

    Args:
        web_acl_id(str): The unique identifier (ID) of the web ACL for which to list the associated resources.
        resource_type(str, optional): The type of resource to list, either an application load balancer or Amazon API Gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.resource.for_web_acl.list(ctx, web_acl_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.resource.for_web_acl.list web_acl_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="list_resources_for_web_acl",
        op_kwargs={"WebACLId": web_acl_id, "ResourceType": resource_type},
    )
