"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    metric_name: str,
    rate_key: str,
    rate_limit: int,
    change_token: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Creates a RateBasedRule. The RateBasedRule contains a RateLimit, which specifies the maximum number of requests that AWS WAF allows from a specified IP address in a five-minute period. The RateBasedRule also contains the IPSet objects, ByteMatchSet objects, and other predicates that identify the requests that you want to count or block if these requests exceed the RateLimit. If you add more than one predicate to a RateBasedRule, a request not only must exceed the RateLimit, but it also must match all the conditions to be counted or blocked. For example, suppose you add the following to a RateBasedRule:   An IPSet that matches the IP address 192.0.2.44/32    A ByteMatchSet that matches BadBot in the User-Agent header   Further, you specify a RateLimit of 1,000. You then add the RateBasedRule to a WebACL and specify that you want to block requests that meet the conditions in the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 and the User-Agent header in the request must contain the value BadBot. Further, requests that match these two conditions must be received at a rate of more than 1,000 requests every five minutes. If both conditions are met and the rate is exceeded, AWS WAF blocks the requests. If the rate drops below 1,000 for a five-minute period, AWS WAF no longer blocks the requests. As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a RateBasedRule:   A ByteMatchSet with FieldToMatch of URI    A PositionalConstraint of STARTS_WITH    A TargetString of login    Further, you specify a RateLimit of 1,000. By adding this RateBasedRule to a WebACL, you could limit requests to your login page without affecting the rest of your site. To create and configure a RateBasedRule, perform the following steps:   Create and update the predicates that you want to include in the rule. For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a CreateRule request.   Submit a CreateRateBasedRule request.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateRule request.   Submit an UpdateRateBasedRule request to specify the predicates that you want to include in the rule.   Create and update a WebACL that contains the RateBasedRule. For more information, see CreateWebACL.   For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        name(str): A friendly name or description of the RateBasedRule. You can't change the name of a RateBasedRule after you create it.
        metric_name(str): A friendly name or description for the metrics for this RateBasedRule. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the RateBasedRule.
        rate_key(str): The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to rate monitoring. The only valid value for RateKey is IP. IP indicates that requests that arrive from the same IP address are subject to the RateLimit that is specified in the RateBasedRule.
        rate_limit(int): The maximum number of requests, which have an identical value in the field that is specified by RateKey, allowed in a five-minute period. If the number of requests exceeds the RateLimit and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
        change_token(str): The ChangeToken that you used to submit the CreateRateBasedRule request. You can also use this value to query the status of the request. For more information, see GetChangeTokenStatus.
        tags(List, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.rate_based_rule.init.create(
                ctx,
                name=value,
                metric_name=value,
                rate_key=value,
                rate_limit=value,
                change_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.rate_based_rule.init.create name=value, metric_name=value, rate_key=value, rate_limit=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="create_rate_based_rule",
        op_kwargs={
            "Name": name,
            "MetricName": metric_name,
            "RateKey": rate_key,
            "RateLimit": rate_limit,
            "ChangeToken": change_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, rule_id: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Permanently deletes a RateBasedRule. You can't delete a rule if it's still used in any WebACL objects or if it still includes any predicates, such as ByteMatchSet objects. If you just want to remove a rule from a WebACL, use UpdateWebACL. To permanently delete a RateBasedRule from AWS WAF, perform the following steps:   Update the RateBasedRule to remove predicates, if any. For more information, see UpdateRateBasedRule.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a DeleteRateBasedRule request.   Submit a DeleteRateBasedRule request.

    Args:
        rule_id(str): The RuleId of the RateBasedRule that you want to delete. RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.rate_based_rule.init.delete(
                ctx, rule_id=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.rate_based_rule.init.delete rule_id=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="delete_rate_based_rule",
        op_kwargs={"RuleId": rule_id, "ChangeToken": change_token},
    )


async def get(hub, ctx, rule_id: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the RateBasedRule that is specified by the RuleId that you included in the GetRateBasedRule request.

    Args:
        rule_id(str): The RuleId of the RateBasedRule that you want to get. RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.rate_based_rule.init.get(ctx, rule_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.rate_based_rule.init.get rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="get_rate_based_rule",
        op_kwargs={"RuleId": rule_id},
    )


async def list_all(hub, ctx, next_marker: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of RuleSummary objects.

    Args:
        next_marker(str, optional): If you specify a value for Limit and you have more Rules than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list another group of Rules. For the second and subsequent ListRateBasedRules requests, specify the value of NextMarker from the previous response to get information about another batch of Rules. Defaults to None.
        limit(int, optional): Specifies the number of Rules that you want AWS WAF to return for this request. If you have more Rules than the number that you specify for Limit, the response includes a NextMarker value that you can use to get another batch of Rules. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.rate_based_rule.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.rate_based_rule.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="list_rate_based_rules",
        op_kwargs={"NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub, ctx, rule_id: str, change_token: str, updates: List, rate_limit: int
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Inserts or deletes Predicate objects in a rule and updates the RateLimit in the rule.  Each Predicate object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests that you want to block or count. The RateLimit specifies the number of requests every five minutes that triggers the rule. If you add more than one predicate to a RateBasedRule, a request must match all the predicates and exceed the RateLimit to be counted or blocked. For example, suppose you add the following to a RateBasedRule:   An IPSet that matches the IP address 192.0.2.44/32    A ByteMatchSet that matches BadBot in the User-Agent header   Further, you specify a RateLimit of 1,000. You then add the RateBasedRule to a WebACL and specify that you want to block requests that satisfy the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 and the User-Agent header in the request must contain the value BadBot. Further, requests that match these two conditions much be received at a rate of more than 1,000 every five minutes. If the rate drops below this limit, AWS WAF no longer blocks the requests. As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a RateBasedRule:   A ByteMatchSet with FieldToMatch of URI    A PositionalConstraint of STARTS_WITH    A TargetString of login    Further, you specify a RateLimit of 1,000. By adding this RateBasedRule to a WebACL, you could limit requests to your login page without affecting the rest of your site.

    Args:
        rule_id(str): The RuleId of the RateBasedRule that you want to update. RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.
        change_token(str): The value returned by the most recent call to GetChangeToken.
        updates(List): An array of RuleUpdate objects that you want to insert into or delete from a RateBasedRule. .
        rate_limit(int): The maximum number of requests, which have an identical value in the field specified by the RateKey, allowed in a five-minute period. If the number of requests exceeds the RateLimit and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.rate_based_rule.init.update(
                ctx, rule_id=value, change_token=value, updates=value, rate_limit=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.rate_based_rule.init.update rule_id=value, change_token=value, updates=value, rate_limit=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="update_rate_based_rule",
        op_kwargs={
            "RuleId": rule_id,
            "ChangeToken": change_token,
            "Updates": updates,
            "RateLimit": rate_limit,
        },
    )
