"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "geo_match_set"


async def create(hub, ctx, name: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Creates an GeoMatchSet, which you use to specify which web requests you want to allow or block based on the country that the requests originate from. For example, if you're receiving a lot of requests from one or more countries and you want to block the requests, you can create an GeoMatchSet that contains those countries and then configure AWS WAF to block the requests.  To create and configure a GeoMatchSet, perform the following steps:   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a CreateGeoMatchSet request.   Submit a CreateGeoMatchSet request.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateGeoMatchSet request.   Submit an UpdateGeoMatchSetSet request to specify the countries that you want AWS WAF to watch for.   For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        name(str): A friendly name or description of the GeoMatchSet. You can't change Name after you create the GeoMatchSet.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.geo_match_set_.create(
                ctx, name=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.geo_match_set.create name=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="create_geo_match_set",
        op_kwargs={"Name": name, "ChangeToken": change_token},
    )


async def delete(hub, ctx, geo_match_set_id: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Permanently deletes a GeoMatchSet. You can't delete a GeoMatchSet if it's still used in any Rules or if it still includes any countries. If you just want to remove a GeoMatchSet from a Rule, use UpdateRule. To permanently delete a GeoMatchSet from AWS WAF, perform the following steps:   Update the GeoMatchSet to remove any countries. For more information, see UpdateGeoMatchSet.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a DeleteGeoMatchSet request.   Submit a DeleteGeoMatchSet request.

    Args:
        geo_match_set_id(str): The GeoMatchSetID of the GeoMatchSet that you want to delete. GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.geo_match_set_.delete(
                ctx, geo_match_set_id=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.geo_match_set.delete geo_match_set_id=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="delete_geo_match_set",
        op_kwargs={"GeoMatchSetId": geo_match_set_id, "ChangeToken": change_token},
    )


async def get(hub, ctx, geo_match_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the GeoMatchSet that is specified by GeoMatchSetId.

    Args:
        geo_match_set_id(str): The GeoMatchSetId of the GeoMatchSet that you want to get. GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.geo_match_set_.get(ctx, geo_match_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.geo_match_set.get geo_match_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="get_geo_match_set",
        op_kwargs={"GeoMatchSetId": geo_match_set_id},
    )


async def list_all(hub, ctx, next_marker: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of GeoMatchSetSummary objects in the response.

    Args:
        next_marker(str, optional): If you specify a value for Limit and you have more GeoMatchSets than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list another group of GeoMatchSet objects. For the second and subsequent ListGeoMatchSets requests, specify the value of NextMarker from the previous response to get information about another batch of GeoMatchSet objects. Defaults to None.
        limit(int, optional): Specifies the number of GeoMatchSet objects that you want AWS WAF to return for this request. If you have more GeoMatchSet objects than the number you specify for Limit, the response includes a NextMarker value that you can use to get another batch of GeoMatchSet objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.geo_match_set_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.geo_match_set.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="list_geo_match_sets",
        op_kwargs={"NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub, ctx, geo_match_set_id: str, change_token: str, updates: List
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet. For each GeoMatchConstraint object, you specify the following values:    Whether to insert or delete the object from the array. If you want to change an GeoMatchConstraint object, you delete the existing object and add a new one.   The Type. The only valid value for Type is Country.   The Value, which is a two character code for the country to add to the GeoMatchConstraint object. Valid codes are listed in GeoMatchConstraint$Value.   To create and configure an GeoMatchSet, perform the following steps:   Submit a CreateGeoMatchSet request.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateGeoMatchSet request.   Submit an UpdateGeoMatchSet request to specify the country that you want AWS WAF to watch for.   When you update an GeoMatchSet, you specify the country that you want to add and/or the country that you want to delete. If you want to change a country, you delete the existing country and add the new one. For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        geo_match_set_id(str): The GeoMatchSetId of the GeoMatchSet that you want to update. GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.
        change_token(str): The value returned by the most recent call to GetChangeToken.
        updates(List): An array of GeoMatchSetUpdate objects that you want to insert into or delete from an GeoMatchSet. For more information, see the applicable data types:    GeoMatchSetUpdate: Contains Action and GeoMatchConstraint     GeoMatchConstraint: Contains Type and Value  You can have only one Type and Value per GeoMatchConstraint. To add multiple countries, include multiple GeoMatchSetUpdate objects in your request.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.geo_match_set_.update(
                ctx, geo_match_set_id=value, change_token=value, updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.geo_match_set.update geo_match_set_id=value, change_token=value, updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="update_geo_match_set",
        op_kwargs={
            "GeoMatchSetId": geo_match_set_id,
            "ChangeToken": change_token,
            "Updates": updates,
        },
    )
