"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the status of a ChangeToken that you got by calling GetChangeToken. ChangeTokenStatus is one of the following values:    PROVISIONED: You requested the change token by calling GetChangeToken, but you haven't used it yet in a call to create, update, or delete an AWS WAF object.    PENDING: AWS WAF is propagating the create, update, or delete request to all AWS WAF servers.    INSYNC: Propagation is complete.

    Args:
        change_token(str): The change token for which you want to get the status. This change token was previously returned in the GetChangeToken response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.change_token.status.get(ctx, change_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.change_token.status.get change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="get_change_token_status",
        op_kwargs={"ChangeToken": change_token},
    )
