"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "size_constraint_set"


async def create(hub, ctx, name: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Creates a SizeConstraintSet. You then use UpdateSizeConstraintSet to identify the part of a web request that you want AWS WAF to check for length, such as the length of the User-Agent header or the length of the query string. For example, you can create a SizeConstraintSet that matches any requests that have a query string that is longer than 100 bytes. You can then configure AWS WAF to reject those requests. To create and configure a SizeConstraintSet, perform the following steps:   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a CreateSizeConstraintSet request.   Submit a CreateSizeConstraintSet request.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateSizeConstraintSet request.   Submit an UpdateSizeConstraintSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.   For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        name(str): A friendly name or description of the SizeConstraintSet. You can't change Name after you create a SizeConstraintSet.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.size_constraint_set_.create(
                ctx, name=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.size_constraint_set.create name=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="create_size_constraint_set",
        op_kwargs={"Name": name, "ChangeToken": change_token},
    )


async def delete(hub, ctx, size_constraint_set_id: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Permanently deletes a SizeConstraintSet. You can't delete a SizeConstraintSet if it's still used in any Rules or if it still includes any SizeConstraint objects (any filters). If you just want to remove a SizeConstraintSet from a Rule, use UpdateRule. To permanently delete a SizeConstraintSet, perform the following steps:   Update the SizeConstraintSet to remove filters, if any. For more information, see UpdateSizeConstraintSet.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a DeleteSizeConstraintSet request.   Submit a DeleteSizeConstraintSet request.

    Args:
        size_constraint_set_id(str): The SizeConstraintSetId of the SizeConstraintSet that you want to delete. SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.size_constraint_set_.delete(
                ctx, size_constraint_set_id=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.size_constraint_set.delete size_constraint_set_id=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="delete_size_constraint_set",
        op_kwargs={
            "SizeConstraintSetId": size_constraint_set_id,
            "ChangeToken": change_token,
        },
    )


async def get(hub, ctx, size_constraint_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the SizeConstraintSet specified by SizeConstraintSetId.

    Args:
        size_constraint_set_id(str): The SizeConstraintSetId of the SizeConstraintSet that you want to get. SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.size_constraint_set_.get(ctx, size_constraint_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.size_constraint_set.get size_constraint_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="get_size_constraint_set",
        op_kwargs={"SizeConstraintSetId": size_constraint_set_id},
    )


async def list_all(hub, ctx, next_marker: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of SizeConstraintSetSummary objects.

    Args:
        next_marker(str, optional): If you specify a value for Limit and you have more SizeConstraintSets than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list another group of SizeConstraintSets. For the second and subsequent ListSizeConstraintSets requests, specify the value of NextMarker from the previous response to get information about another batch of SizeConstraintSets. Defaults to None.
        limit(int, optional): Specifies the number of SizeConstraintSet objects that you want AWS WAF to return for this request. If you have more SizeConstraintSets objects than the number you specify for Limit, the response includes a NextMarker value that you can use to get another batch of SizeConstraintSet objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.size_constraint_set_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.size_constraint_set.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="list_size_constraint_sets",
        op_kwargs={"NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub, ctx, size_constraint_set_id: str, change_token: str, updates: List
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet. For each SizeConstraint object, you specify the following values:    Whether to insert or delete the object from the array. If you want to change a SizeConstraintSetUpdate object, you delete the existing object and add a new one.   The part of a web request that you want AWS WAF to evaluate, such as the length of a query string or the length of the User-Agent header.   Whether to perform any transformations on the request, such as converting it to lowercase, before checking its length. Note that transformations of the request body are not supported because the AWS resource forwards only the first 8192 bytes of your request to AWS WAF. You can only specify a single type of TextTransformation.   A ComparisonOperator used for evaluating the selected part of the request against the specified Size, such as equals, greater than, less than, and so on.   The length, in bytes, that you want AWS WAF to watch for in selected part of the request. The length is computed after applying the transformation.   For example, you can add a SizeConstraintSetUpdate object that matches web requests in which the length of the User-Agent header is greater than 100 bytes. You can then configure AWS WAF to block those requests. To create and configure a SizeConstraintSet, perform the following steps:   Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateSizeConstraintSet request.   Submit an UpdateSizeConstraintSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.   For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        size_constraint_set_id(str): The SizeConstraintSetId of the SizeConstraintSet that you want to update. SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
        change_token(str): The value returned by the most recent call to GetChangeToken.
        updates(List): An array of SizeConstraintSetUpdate objects that you want to insert into or delete from a SizeConstraintSet. For more information, see the applicable data types:    SizeConstraintSetUpdate: Contains Action and SizeConstraint     SizeConstraint: Contains FieldToMatch, TextTransformation, ComparisonOperator, and Size     FieldToMatch: Contains Data and Type   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.size_constraint_set_.update(
                ctx, size_constraint_set_id=value, change_token=value, updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.size_constraint_set.update size_constraint_set_id=value, change_token=value, updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="update_size_constraint_set",
        op_kwargs={
            "SizeConstraintSetId": size_constraint_set_id,
            "ChangeToken": change_token,
            "Updates": updates,
        },
    )
