"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, metric_name: str, change_token: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Creates a RuleGroup. A rule group is a collection of predefined rules that you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group. Rule groups are subject to the following limits:   Three rule groups per account. You can request an increase to this limit by contacting customer support.   One rule group per web ACL.   Ten rules per rule group.   For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        name(str): A friendly name or description of the RuleGroup. You can't change Name after you create a RuleGroup.
        metric_name(str): A friendly name or description for the metrics for this RuleGroup. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the RuleGroup.
        change_token(str): The value returned by the most recent call to GetChangeToken.
        tags(List, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rule.group.create(
                ctx, name=value, metric_name=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rule.group.create name=value, metric_name=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="create_rule_group",
        op_kwargs={
            "Name": name,
            "MetricName": metric_name,
            "ChangeToken": change_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, rule_group_id: str, change_token: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Permanently deletes a RuleGroup. You can't delete a RuleGroup if it's still used in any WebACL objects or if it still includes any rules. If you just want to remove a RuleGroup from a WebACL, use UpdateWebACL. To permanently delete a RuleGroup from AWS WAF, perform the following steps:   Update the RuleGroup to remove rules, if any. For more information, see UpdateRuleGroup.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of a DeleteRuleGroup request.   Submit a DeleteRuleGroup request.

    Args:
        rule_group_id(str): The RuleGroupId of the RuleGroup that you want to delete. RuleGroupId is returned by CreateRuleGroup and by ListRuleGroups.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rule.group.delete(
                ctx, rule_group_id=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rule.group.delete rule_group_id=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="delete_rule_group",
        op_kwargs={"RuleGroupId": rule_group_id, "ChangeToken": change_token},
    )


async def get(hub, ctx, rule_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the RuleGroup that is specified by the RuleGroupId that you included in the GetRuleGroup request. To view the rules in a rule group, use ListActivatedRulesInRuleGroup.

    Args:
        rule_group_id(str): The RuleGroupId of the RuleGroup that you want to get. RuleGroupId is returned by CreateRuleGroup and by ListRuleGroups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rule.group.get(ctx, rule_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rule.group.get rule_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="get_rule_group",
        op_kwargs={"RuleGroupId": rule_group_id},
    )


async def list_all(hub, ctx, next_marker: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of RuleGroup objects.

    Args:
        next_marker(str, optional): If you specify a value for Limit and you have more RuleGroups than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list another group of RuleGroups. For the second and subsequent ListRuleGroups requests, specify the value of NextMarker from the previous response to get information about another batch of RuleGroups. Defaults to None.
        limit(int, optional): Specifies the number of RuleGroups that you want AWS WAF to return for this request. If you have more RuleGroups than the number that you specify for Limit, the response includes a NextMarker value that you can use to get another batch of RuleGroups. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rule.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rule.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="list_rule_groups",
        op_kwargs={"NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub, ctx, rule_group_id: str, updates: List, change_token: str
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Inserts or deletes ActivatedRule objects in a RuleGroup. You can only insert REGULAR rules into a rule group. You can have a maximum of ten rules per rule group. To create and configure a RuleGroup, perform the following steps:   Create and update the Rules that you want to include in the RuleGroup. See CreateRule.   Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of an UpdateRuleGroup request.   Submit an UpdateRuleGroup request to add Rules to the RuleGroup.   Create and update a WebACL that contains the RuleGroup. See CreateWebACL.   If you want to replace one Rule with another, you delete the existing one and add the new one. For more information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

    Args:
        rule_group_id(str): The RuleGroupId of the RuleGroup that you want to update. RuleGroupId is returned by CreateRuleGroup and by ListRuleGroups.
        updates(List): An array of RuleGroupUpdate objects that you want to insert into or delete from a RuleGroup. You can only insert REGULAR rules into a rule group.  ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup to a WebACL. In this case you do not use ActivatedRule|Action. For all other update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
        change_token(str): The value returned by the most recent call to GetChangeToken.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rule.group.update(
                ctx, rule_group_id=value, updates=value, change_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rule.group.update rule_group_id=value, updates=value, change_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="update_rule_group",
        op_kwargs={
            "RuleGroupId": rule_group_id,
            "Updates": updates,
            "ChangeToken": change_token,
        },
    )
