"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, rule_id: str, next_marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns an array of IP addresses currently being blocked by the RateBasedRule that is specified by the RuleId. The maximum number of managed keys that will be blocked is 10,000. If more than 10,000 addresses exceed the rate limit, the 10,000 addresses with the highest rates will be blocked.

    Args:
        rule_id(str): The RuleId of the RateBasedRule for which you want to get a list of ManagedKeys. RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.
        next_marker(str, optional): A null value and not currently used. Do not include this in your request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.rate_based_rule.managed_key.get_all(ctx, rule_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.rate_based_rule.managed_key.get_all rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="get_rate_based_rule_managed_keys",
        op_kwargs={"RuleId": rule_id, "NextMarker": next_marker},
    )
