"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Permanently deletes an IAM policy from the specified RuleGroup. The user making the request must be the owner of the RuleGroup.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy. The user making the request must be the owner of the RuleGroup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.permission_policy.delete(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.permission_policy.delete resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="delete_permission_policy",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def get(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Returns the IAM policy attached to the RuleGroup.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.permission_policy.get(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.permission_policy.get resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="get_permission_policy",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def put(hub, ctx, resource_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Attaches an IAM policy to the specified resource. The only supported use for this action is to share a RuleGroup across accounts. The PutPermissionPolicy is subject to the following restrictions:   You can attach only one policy with each PutPermissionPolicy request.   The policy must include an Effect, Action and Principal.     Effect must specify Allow.   The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL, waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard actions in the policy will be rejected.   The policy cannot include a Resource parameter.   The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.   The user making the request must be the owner of the RuleGroup.   Your policy must be composed using IAM Policy version 2012-10-17.   For more information, see IAM Policies.  An example of a valid policy parameter is shown in the Examples section below.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.
        policy(str): The policy to attach to the specified RuleGroup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf.permission_policy.put(ctx, resource_arn=value, policy=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf.permission_policy.put resource_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf",
        operation="put_permission_policy",
        op_kwargs={"ResourceArn": resource_arn, "Policy": policy},
    )
