"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with an asycnhronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.

    Args:
        job_id(str): The identifier that Amazon Translate generated for the job. The StartTextTranslationJob operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.text.translation_job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.text.translation_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="describe_text_translation_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the batch translation jobs that you have submitted.

    Args:
        filter_(Dict, optional): The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.text.translation_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.text.translation_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="list_text_translation_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    output_data_config: Dict,
    data_access_role_arn: str,
    source_language_code: str,
    target_language_codes: List,
    client_token: str,
    job_name: str = None,
    terminology_names: List = None,
    parallel_data_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once. For more information, see async. Batch translation jobs can be described with the DescribeTextTranslationJob operation, listed with the ListTextTranslationJobs operation, and stopped with the StopTextTranslationJob operation.  Amazon Translate does not support batch translation of multiple source languages at once.

    Args:
        job_name(str, optional): The name of the batch translation job to be performed. Defaults to None.
        input_data_config(Dict): Specifies the format and S3 location of the input documents for the translation job.
        output_data_config(Dict): Specifies the S3 folder to which your job output will be saved. .
        data_access_role_arn(str): The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more nformation, see identity-and-access-management.
        source_language_code(str): The language code of the input language. For a list of language codes, see what-is-languages. Amazon Translate does not automatically detect a source language during batch translation jobs.
        target_language_codes(List): The language code of the output language.
        terminology_names(List, optional): The name of the terminology to use in the batch translation job. For a list of available terminologies, use the ListTerminologies operation. Defaults to None.
        parallel_data_names(List, optional): The names of the parallel data resources to use in the batch translation job. For a list of available parallel data resources, use the ListParallelData operation. Defaults to None.
        client_token(str): A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.text.translation_job.start(
                ctx,
                input_data_config=value,
                output_data_config=value,
                data_access_role_arn=value,
                source_language_code=value,
                target_language_codes=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.text.translation_job.start input_data_config=value, output_data_config=value, data_access_role_arn=value, source_language_code=value, target_language_codes=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="start_text_translation_job",
        op_kwargs={
            "JobName": job_name,
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "DataAccessRoleArn": data_access_role_arn,
            "SourceLanguageCode": source_language_code,
            "TargetLanguageCodes": target_language_codes,
            "TerminologyNames": terminology_names,
            "ParallelDataNames": parallel_data_names,
            "ClientToken": client_token,
        },
    )


async def stop(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops an asynchronous batch translation job that is in progress. If the job's state is IN_PROGRESS, the job will be marked for termination and put into the STOP_REQUESTED state. If the job completes before it can be stopped, it is put into the COMPLETED state. Otherwise, the job is put into the STOPPED state. Asynchronous batch translation jobs are started with the StartTextTranslationJob operation. You can use the DescribeTextTranslationJob or ListTextTranslationJobs operations to get a batch translation job's JobId.

    Args:
        job_id(str): The job ID of the job to be stopped.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.text.translation_job.stop(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.text.translation_job.stop job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="stop_text_translation_job",
        op_kwargs={"JobId": job_id},
    )
