"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def translate(
    hub,
    ctx,
    text: str,
    source_language_code: str,
    target_language_code: str,
    terminology_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Translates input text from the source language to the target language. For a list of available languages and language codes, see what-is-languages.

    Args:
        text(str): The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.
        terminology_names(List, optional): The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a TranslateText request. Terminology lists can contain a maximum of 256 terms. Defaults to None.
        source_language_code(str): The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see what-is-languages. To have Amazon Translate determine the source language of your text, you can specify auto in the SourceLanguageCode field. If you specify auto, Amazon Translate will call Amazon Comprehend to determine the source language.
        target_language_code(str): The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.text.init.translate(
                ctx, text=value, source_language_code=value, target_language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.text.init.translate text=value, source_language_code=value, target_language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="translate_text",
        op_kwargs={
            "Text": text,
            "TerminologyNames": terminology_names,
            "SourceLanguageCode": source_language_code,
            "TargetLanguageCode": target_language_code,
        },
    )
