"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def delete(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    A synchronous action that deletes a custom terminology.

    Args:
        name(str): The name of the custom terminology being deleted. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.terminology.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.terminology.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="delete_terminology",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str, terminology_data_format: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a custom terminology.

    Args:
        name(str): The name of the custom terminology being retrieved.
        terminology_data_format(str): The data format of the custom terminology being retrieved, either CSV or TMX.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.terminology.get(ctx, name=value, terminology_data_format=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.terminology.get name=value, terminology_data_format=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="get_terminology",
        op_kwargs={"Name": name, "TerminologyDataFormat": terminology_data_format},
    )


async def import_(
    hub,
    ctx,
    name: str,
    merge_strategy: str,
    terminology_data: Dict,
    description: str = None,
    encryption_key: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name. Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen merge strategy. Currently, the only supported merge strategy is OVERWRITE, and so the imported terminology will overwrite an existing terminology of the same name. If you import a terminology that overwrites an existing one, the new terminology take up to 10 minutes to fully propagate and be available for use in a translation due to cache policies with the DataPlane service that performs the translations.

    Args:
        name(str): The name of the custom terminology being imported.
        merge_strategy(str): The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
        description(str, optional): The description of the custom terminology being imported. Defaults to None.
        terminology_data(Dict): The terminology data for the custom terminology being imported.
        encryption_key(Dict, optional): The encryption key for the custom terminology being imported. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.terminology.import(ctx, name=value, merge_strategy=value, terminology_data=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.terminology.import name=value, merge_strategy=value, terminology_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="import_terminology",
        op_kwargs={
            "Name": name,
            "MergeStrategy": merge_strategy,
            "Description": description,
            "TerminologyData": terminology_data,
            "EncryptionKey": encryption_key,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of custom terminologies associated with your account.

    Args:
        next_token(str, optional): If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. . Defaults to None.
        max_results(int, optional): The maximum number of custom terminologies returned per list request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.terminology.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.terminology.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="list_terminologies",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
