"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def create(
    hub,
    ctx,
    name: str,
    parallel_data_config: Dict,
    client_token: str,
    description: str = None,
    encryption_key: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data files contain examples of source phrases and their translations from your translation memory. By adding parallel data, you can influence the style, tone, and word choice in your translation output.

    Args:
        name(str): A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.
        description(str, optional): A custom description for the parallel data resource in Amazon Translate. Defaults to None.
        parallel_data_config(Dict): Specifies the format and S3 location of the parallel data input file.
        encryption_key(Dict, optional): The encryption key used to encrypt this object. Defaults to None.
        client_token(str): A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.parallel_data.create(
                ctx, name=value, parallel_data_config=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.parallel_data.create name=value, parallel_data_config=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="create_parallel_data",
        op_kwargs={
            "Name": name,
            "Description": description,
            "ParallelDataConfig": parallel_data_config,
            "EncryptionKey": encryption_key,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a parallel data resource in Amazon Translate.

    Args:
        name(str): The name of the parallel data resource that is being deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.parallel_data.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.parallel_data.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="delete_parallel_data",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a parallel data resource.

    Args:
        name(str): The name of the parallel data resource that is being retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.parallel_data.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.parallel_data.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="get_parallel_data",
        op_kwargs={"Name": name},
    )


async def list_(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of your parallel data resources in Amazon Translate.

    Args:
        next_token(str, optional): A string that specifies the next page of results to return in a paginated response. Defaults to None.
        max_results(int, optional): The maximum number of parallel data resources returned for each request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.parallel_data.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.parallel_data.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="list_parallel_data",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    name: str,
    parallel_data_config: Dict,
    client_token: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a previously created parallel data resource by importing a new input file from Amazon S3.

    Args:
        name(str): The name of the parallel data resource being updated.
        description(str, optional): A custom description for the parallel data resource in Amazon Translate. Defaults to None.
        parallel_data_config(Dict): Specifies the format and S3 location of the parallel data input file.
        client_token(str): A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.translate.parallel_data.update(
                ctx, name=value, parallel_data_config=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.translate.parallel_data.update name=value, parallel_data_config=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="translate",
        operation="update_parallel_data",
        op_kwargs={
            "Name": name,
            "Description": description,
            "ParallelDataConfig": parallel_data_config,
            "ClientToken": client_token,
        },
    )
