"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    role: str,
    server_id: str,
    user_name: str,
    home_directory: str = None,
    home_directory_type: str = None,
    home_directory_mappings: List = None,
    policy: str = None,
    posix_profile: Dict = None,
    ssh_public_key_body: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the IdentityProviderType set to SERVICE_MANAGED. Using parameters for CreateUser, you can specify the user name, set the home directory, store the user's public key, and assign the user's Amazon Web Services Identity and Access Management (IAM) role. You can also optionally add a scope-down policy, and assign metadata with tags that can be used to group and search for users.

    Args:
        home_directory(str, optional): The landing directory (folder) for a user when they log in to the server using the client. A HomeDirectory example is /bucket_name/home/mydirectory. Defaults to None.
        home_directory_type(str, optional): The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to your users. Defaults to None.
        home_directory_mappings(List, optional): Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the Entry and Target pair, where Entry shows how the path is made visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in Target. This value can only be set when HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [ { "Entry": "your-personal-report.pdf", "Target": "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]  In most cases, you can use this value instead of the scope-down policy to lock your user down to the designated home directory ("chroot"). To do this, you can set Entry to / and set Target to the HomeDirectory parameter value. The following is an Entry and Target pair example for chroot.  [ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]   If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the s3api or efsapi call instead of s3 or efs so you can use the put-object operation. For example, you use the following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make sure that the end of the key name ends in a / for it to be considered a folder. . Defaults to None.
        policy(str, optional): A scope-down policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.  This only applies when domain of ServerId is S3. EFS does not use scope down policy. For scope-down policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the Policy argument. For an example of a scope-down policy, see Example scope-down policy. For more information, see AssumeRole in the Amazon Web Services Security Token Service API Reference. . Defaults to None.
        posix_profile(Dict, optional): Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in Amazon EFS determine the level of access your users get when transferring files into and out of your Amazon EFS file systems. Defaults to None.
        role(str): Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
        server_id(str): A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.
        ssh_public_key_body(str, optional): The public portion of the Secure Shell (SSH) key used to authenticate the user to the server. Defaults to None.
        tags(List, optional): Key-value pairs that can be used to group and search for users. Tags are metadata attached to users for any purpose. Defaults to None.
        user_name(str): A unique string that identifies a user and is associated with a as specified by the ServerId. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.user.create(
                ctx, role=value, server_id=value, user_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.user.create role=value, server_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="create_user",
        op_kwargs={
            "HomeDirectory": home_directory,
            "HomeDirectoryType": home_directory_type,
            "HomeDirectoryMappings": home_directory_mappings,
            "Policy": policy,
            "PosixProfile": posix_profile,
            "Role": role,
            "ServerId": server_id,
            "SshPublicKeyBody": ssh_public_key_body,
            "Tags": tags,
            "UserName": user_name,
        },
    )


async def delete(hub, ctx, server_id: str, user_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the user belonging to a file transfer protocol-enabled server you specify. No response returns from this operation.  When you delete a user from a server, the user's information is lost.

    Args:
        server_id(str): A system-assigned unique identifier for a server instance that has the user assigned to it.
        user_name(str): A unique string that identifies a user that is being deleted from a server.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.user.delete(ctx, server_id=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.user.delete server_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="delete_user",
        op_kwargs={"ServerId": server_id, "UserName": user_name},
    )


async def describe(hub, ctx, server_id: str, user_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its ServerId property. The response from this call returns the properties of the user associated with the ServerId value that was specified.

    Args:
        server_id(str): A system-assigned unique identifier for a server that has this user assigned.
        user_name(str): The name of the user assigned to one or more servers. User names are part of the sign-in credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.user.describe(ctx, server_id=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.user.describe server_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="describe_user",
        op_kwargs={"ServerId": server_id, "UserName": user_name},
    )


async def list_all(
    hub, ctx, server_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the users for a file transfer protocol-enabled server that you specify by passing the ServerId parameter.

    Args:
        max_results(int, optional): Specifies the number of users to return as a response to the ListUsers request. Defaults to None.
        next_token(str, optional): When you can get additional results from the ListUsers call, a NextToken parameter is returned in the output. You can then pass in a subsequent command to the NextToken parameter to continue listing additional users. Defaults to None.
        server_id(str): A system-assigned unique identifier for a server that has users assigned to it.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.user.list_all(ctx, server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.user.list_all server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="list_users",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ServerId": server_id,
        },
    )


async def update(
    hub,
    ctx,
    server_id: str,
    user_name: str,
    home_directory: str = None,
    home_directory_type: str = None,
    home_directory_mappings: List = None,
    policy: str = None,
    posix_profile: Dict = None,
    role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the UserName and ServerId you specify. The response returns the ServerId and the UserName for the updated user.

    Args:
        home_directory(str, optional): The landing directory (folder) for a user when they log in to the server using the client. A HomeDirectory example is /bucket_name/home/mydirectory. Defaults to None.
        home_directory_type(str, optional): The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to your users. Defaults to None.
        home_directory_mappings(List, optional): Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the Entry and Target pair, where Entry shows how the path is made visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in Target. This value can only be set when HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [ { "Entry": "your-personal-report.pdf", "Target": "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]  In most cases, you can use this value instead of the scope-down policy to lock down your user to the designated home directory ("chroot"). To do this, you can set Entry to '/' and set Target to the HomeDirectory parameter value. The following is an Entry and Target pair example for chroot.  [ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]   If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the s3api or efsapi call instead of s3 or efs so you can use the put-object operation. For example, you use the following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make sure that the end of the key name ends in a / for it to be considered a folder. . Defaults to None.
        policy(str, optional): A scope-down policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.  This only applies when domain of ServerId is S3. Amazon EFS does not use scope-down policies. For scope-down policies, Amazon Web ServicesTransfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the Policy argument. For an example of a scope-down policy, see Creating a scope-down policy. For more information, see AssumeRole in the Amazon Web Services Security Token Service API Reference. . Defaults to None.
        posix_profile(Dict, optional): Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files and directories in your file system determines the level of access your users get when transferring files into and out of your Amazon EFS file systems. Defaults to None.
        role(str, optional): Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests. Defaults to None.
        server_id(str): A system-assigned unique identifier for a server instance that the user account is assigned to.
        user_name(str): A unique string that identifies a user and is associated with a server as specified by the ServerId. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.user.update(ctx, server_id=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.user.update server_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="update_user",
        op_kwargs={
            "HomeDirectory": home_directory,
            "HomeDirectoryType": home_directory_type,
            "HomeDirectoryMappings": home_directory_mappings,
            "Policy": policy,
            "PosixProfile": posix_profile,
            "Role": role,
            "ServerId": server_id,
            "UserName": user_name,
        },
    )
