"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.

    Args:
        arn(str): Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.
        max_results(int, optional): Specifies the number of tags to return as a response to the ListTagsForResource request. Defaults to None.
        next_token(str, optional): When you request additional results from the ListTagsForResource operation, a NextToken parameter is returned in the input. You can then pass in a subsequent command to the NextToken parameter to continue listing additional tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.tags_for_resource.list(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.tags_for_resource.list arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="list_tags_for_resource",
        op_kwargs={"Arn": arn, "MaxResults": max_results, "NextToken": next_token},
    )
