"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def delete(
    hub, ctx, server_id: str, ssh_public_key_id: str, user_name: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes a user's Secure Shell (SSH) public key. No response is returned from this operation.

    Args:
        server_id(str): A system-assigned unique identifier for a file transfer protocol-enabled server instance that has the user assigned to it.
        ssh_public_key_id(str): A unique identifier used to reference your user's specific SSH key.
        user_name(str): A unique string that identifies a user whose public key is being deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.ssh_public_key.delete(ctx, server_id=value, ssh_public_key_id=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.ssh_public_key.delete server_id=value, ssh_public_key_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="delete_ssh_public_key",
        op_kwargs={
            "ServerId": server_id,
            "SshPublicKeyId": ssh_public_key_id,
            "UserName": user_name,
        },
    )


async def import_(
    hub, ctx, server_id: str, ssh_public_key_body: str, user_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a Secure Shell (SSH) public key to a user account identified by a UserName value assigned to the specific file transfer protocol-enabled server, identified by ServerId. The response returns the UserName value, the ServerId value, and the name of the SshPublicKeyId.

    Args:
        server_id(str): A system-assigned unique identifier for a server.
        ssh_public_key_body(str): The public key portion of an SSH key pair.
        user_name(str): The name of the user account that is assigned to one or more servers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.ssh_public_key.import(ctx, server_id=value, ssh_public_key_body=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.ssh_public_key.import server_id=value, ssh_public_key_body=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="import_ssh_public_key",
        op_kwargs={
            "ServerId": server_id,
            "SshPublicKeyBody": ssh_public_key_body,
            "UserName": user_name,
        },
    )
