"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, security_policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see Working with security policies.

    Args:
        security_policy_name(str): Specifies the name of the security policy that is attached to the server.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.security_policy.describe(
                ctx, security_policy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.security_policy.describe security_policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="describe_security_policy",
        op_kwargs={"SecurityPolicyName": security_policy_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the security policies that are attached to your file transfer protocol-enabled servers.

    Args:
        max_results(int, optional): Specifies the number of security policies to return as a response to the ListSecurityPolicies query. Defaults to None.
        next_token(str, optional): When additional results are obtained from the ListSecurityPolicies command, a NextToken parameter is returned in the output. You can then pass the NextToken parameter in a subsequent command to continue listing additional security policies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.security_policy.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.security_policy.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="list_security_policies",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
