"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(
    hub,
    ctx,
    server_id: str,
    user_name: str,
    server_protocol: str = None,
    source_ip: str = None,
    user_password: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    If the IdentityProviderType of a file transfer protocol-enabled server is AWS_DIRECTORY_SERVICE or API_Gateway, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.

    Args:
        server_id(str): A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.
        server_protocol(str, optional): The type of file transfer protocol to be tested. The available protocols are:   Secure Shell (SSH) File Transfer Protocol (SFTP)   File Transfer Protocol Secure (FTPS)   File Transfer Protocol (FTP)  . Defaults to None.
        source_ip(str, optional): The source IP address of the user account to be tested. Defaults to None.
        user_name(str): The name of the user account to be tested.
        user_password(str, optional): The password of the user account to be tested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.identity_provider.test(
                ctx, server_id=value, user_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.identity_provider.test server_id=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="test_identity_provider",
        op_kwargs={
            "ServerId": server_id,
            "ServerProtocol": server_protocol,
            "SourceIp": source_ip,
            "UserName": user_name,
            "UserPassword": user_password,
        },
    )
