"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    role: str,
    server_id: str,
    external_id: str,
    home_directory: str = None,
    home_directory_type: str = None,
    home_directory_mappings: List = None,
    policy: str = None,
    posix_profile: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Amazon Web Services Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use CreateAccess to limit the access to the correct set of users who need this ability.

    Args:
        home_directory(str, optional): The landing directory (folder) for a user when they log in to the server using the client. A HomeDirectory example is /bucket_name/home/mydirectory. Defaults to None.
        home_directory_type(str, optional): The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to your users. Defaults to None.
        home_directory_mappings(List, optional): Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the Entry and Target pair, where Entry shows how the path is made visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in Target. This value can only be set when HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [ { "Entry": "your-personal-report.pdf", "Target": "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]  In most cases, you can use this value instead of the scope-down policy to lock down your user to the designated home directory ("chroot"). To do this, you can set Entry to / and set Target to the HomeDirectory parameter value. The following is an Entry and Target pair example for chroot.  [ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]   If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the s3api or efsapi call instead of s3 or efs so you can use the put-object operation. For example, you use the following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make sure that the end of the key name ends in a / for it to be considered a folder. . Defaults to None.
        policy(str, optional): A scope-down policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.  This only applies when domain of ServerId is S3. Amazon EFS does not use scope-down policies. For scope-down policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the Policy argument. For an example of a scope-down policy, see Example scope-down policy. For more information, see AssumeRole in the Amazon Web Services Security Token Service API Reference. . Defaults to None.
        posix_profile(Dict, optional): The full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems. Defaults to None.
        role(str): Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
        server_id(str): A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.
        external_id(str): A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.  Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of your Active Directory group. The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.access.create(
                ctx, role=value, server_id=value, external_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.access.create role=value, server_id=value, external_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="create_access",
        op_kwargs={
            "HomeDirectory": home_directory,
            "HomeDirectoryType": home_directory_type,
            "HomeDirectoryMappings": home_directory_mappings,
            "Policy": policy,
            "PosixProfile": posix_profile,
            "Role": role,
            "ServerId": server_id,
            "ExternalId": external_id,
        },
    )


async def delete(hub, ctx, server_id: str, external_id: str) -> None:
    r"""
    **Autogenerated function**

    Allows you to delete the access specified in the ServerID and ExternalID parameters.

    Args:
        server_id(str): A system-assigned unique identifier for a server that has this user assigned.
        external_id(str): A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.  Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of your Active Directory group. The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.access.delete(ctx, server_id=value, external_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.access.delete server_id=value, external_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="delete_access",
        op_kwargs={"ServerId": server_id, "ExternalId": external_id},
    )


async def describe(hub, ctx, server_id: str, external_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its ServerId property and its ExternalID. The response from this call returns the properties of the access that is associated with the ServerId value that was specified.

    Args:
        server_id(str): A system-assigned unique identifier for a server that has this access assigned.
        external_id(str): A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.  Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of your Active Directory group. The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.access.describe(
                ctx, server_id=value, external_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.access.describe server_id=value, external_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="describe_access",
        op_kwargs={"ServerId": server_id, "ExternalId": external_id},
    )


async def list_all(
    hub, ctx, server_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the details for all the accesses you have on your server.

    Args:
        max_results(int, optional): Specifies the maximum number of access SIDs to return. Defaults to None.
        next_token(str, optional): When you can get additional results from the ListAccesses call, a NextToken parameter is returned in the output. You can then pass in a subsequent command to the NextToken parameter to continue listing additional accesses. Defaults to None.
        server_id(str): A system-assigned unique identifier for a server that has users assigned to it.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.access.list_all(ctx, server_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.access.list_all server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="list_accesses",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ServerId": server_id,
        },
    )


async def update(
    hub,
    ctx,
    server_id: str,
    external_id: str,
    home_directory: str = None,
    home_directory_type: str = None,
    home_directory_mappings: List = None,
    policy: str = None,
    posix_profile: Dict = None,
    role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to update parameters for the access specified in the ServerID and ExternalID parameters.

    Args:
        home_directory(str, optional): The landing directory (folder) for a user when they log in to the server using the client. A HomeDirectory example is /bucket_name/home/mydirectory. Defaults to None.
        home_directory_type(str, optional): The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to your users. Defaults to None.
        home_directory_mappings(List, optional): Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the Entry and Target pair, where Entry shows how the path is made visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in Target. This value can only be set when HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [ { "Entry": "your-personal-report.pdf", "Target": "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]  In most cases, you can use this value instead of the scope-down policy to lock down your user to the designated home directory ("chroot"). To do this, you can set Entry to / and set Target to the HomeDirectory parameter value. The following is an Entry and Target pair example for chroot.  [ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]   If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the s3api or efsapi call instead of s3 or efs so you can use the put-object operation. For example, you use the following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make sure that the end of the key name ends in a / for it to be considered a folder. . Defaults to None.
        policy(str, optional): A scope-down policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.  This only applies when domain of ServerId is S3. Amazon EFS does not use scope down policy. For scope-down policies, Amazon Web ServicesTransfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the Policy argument. For an example of a scope-down policy, see Example scope-down policy. For more information, see AssumeRole in the Amazon Web ServicesSecurity Token Service API Reference. . Defaults to None.
        posix_profile(Dict, optional): The full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems. Defaults to None.
        role(str, optional): Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests. Defaults to None.
        server_id(str): A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.
        external_id(str): A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.  Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties * | Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of your Active Directory group. The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transfer.access.update(ctx, server_id=value, external_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transfer.access.update server_id=value, external_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transfer",
        operation="update_access",
        op_kwargs={
            "HomeDirectory": home_directory,
            "HomeDirectoryType": home_directory_type,
            "HomeDirectoryMappings": home_directory_mappings,
            "Policy": policy,
            "PosixProfile": posix_profile,
            "Role": role,
            "ServerId": server_id,
            "ExternalId": external_id,
        },
    )
