"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    vocabulary_name: str,
    language_code: str,
    phrases: List = None,
    vocabulary_file_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.

    Args:
        vocabulary_name(str): The name of the vocabulary. The name must be unique within an AWS account. The name is case sensitive. If you try to create a vocabulary with the same name as a previous vocabulary you will receive a ConflictException error.
        language_code(str): The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see what-is-transcribe.
        phrases(List, optional): An array of strings that contains the vocabulary entries. . Defaults to None.
        vocabulary_file_uri(str, optional): The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is  For more information about S3 object names, see Object Keys in the Amazon S3 Developer Guide. For more information about custom vocabularies, see Custom Vocabularies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.init.create(
                ctx, vocabulary_name=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.init.create vocabulary_name=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="create_vocabulary",
        op_kwargs={
            "VocabularyName": vocabulary_name,
            "LanguageCode": language_code,
            "Phrases": phrases,
            "VocabularyFileUri": vocabulary_file_uri,
        },
    )


async def delete(hub, ctx, vocabulary_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a vocabulary from Amazon Transcribe.

    Args:
        vocabulary_name(str): The name of the vocabulary to delete. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.init.delete(ctx, vocabulary_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.init.delete vocabulary_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_vocabulary",
        op_kwargs={"VocabularyName": vocabulary_name},
    )


async def get(hub, ctx, vocabulary_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a vocabulary.

    Args:
        vocabulary_name(str): The name of the vocabulary to return information about. The name is case sensitive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.init.get(ctx, vocabulary_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.init.get vocabulary_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="get_vocabulary",
        op_kwargs={"VocabularyName": vocabulary_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    state_equals: str = None,
    name_contains: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.

    Args:
        next_token(str, optional): If the result of the previous request to ListVocabularies was truncated, include the NextToken to fetch the next set of jobs. Defaults to None.
        max_results(int, optional): The maximum number of vocabularies to return in the response. If there are fewer results in the list, this response contains only the actual results. Defaults to None.
        state_equals(str, optional): When specified, only returns vocabularies with the VocabularyState field equal to the specified state. Defaults to None.
        name_contains(str, optional): When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the specified string. The search is not case sensitive, ListVocabularies returns both "vocabularyname" and "VocabularyName" in the response list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_vocabularies",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "StateEquals": state_equals,
            "NameContains": name_contains,
        },
    )


async def update(
    hub,
    ctx,
    vocabulary_name: str,
    language_code: str,
    phrases: List = None,
    vocabulary_file_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.

    Args:
        vocabulary_name(str): The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a previous vocabulary you will receive a ConflictException error.
        language_code(str): The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see what-is-transcribe.
        phrases(List, optional): An array of strings containing the vocabulary entries. Defaults to None.
        vocabulary_file_uri(str, optional): The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is  For example: For more information about S3 object names, see Object Keys in the Amazon S3 Developer Guide. For more information about custom vocabularies, see Custom Vocabularies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.init.update(
                ctx, vocabulary_name=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.init.update vocabulary_name=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="update_vocabulary",
        op_kwargs={
            "VocabularyName": vocabulary_name,
            "LanguageCode": language_code,
            "Phrases": phrases,
            "VocabularyFileUri": vocabulary_file_uri,
        },
    )
