"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "filter"


async def create(
    hub,
    ctx,
    vocabulary_filter_name: str,
    language_code: str,
    words: List = None,
    vocabulary_filter_file_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a transcription job.

    Args:
        vocabulary_filter_name(str): The vocabulary filter name. The name must be unique within the account that contains it. If you try to create a vocabulary filter with the same name as another vocabulary filter, you get a ConflictException error.
        language_code(str): The language code of the words in the vocabulary filter. All words in the filter must be in the same language. The vocabulary filter can only be used with transcription jobs in the specified language.
        words(List, optional): The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see Character Sets for Custom Vocabularies. If you provide a list of words in the Words parameter, you can't use the VocabularyFilterFileUri parameter. Defaults to None.
        vocabulary_filter_file_uri(str, optional): The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see Character Sets for Custom Vocabularies. The specified file must be less than 50 KB of UTF-8 characters. If you provide the location of a list of words in the VocabularyFilterFileUri parameter, you can't use the Words parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.filter_.create(
                ctx, vocabulary_filter_name=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.filter.create vocabulary_filter_name=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="create_vocabulary_filter",
        op_kwargs={
            "VocabularyFilterName": vocabulary_filter_name,
            "LanguageCode": language_code,
            "Words": words,
            "VocabularyFilterFileUri": vocabulary_filter_file_uri,
        },
    )


async def delete(hub, ctx, vocabulary_filter_name: str) -> None:
    r"""
    **Autogenerated function**

    Removes a vocabulary filter.

    Args:
        vocabulary_filter_name(str): The name of the vocabulary filter to remove.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.filter_.delete(
                ctx, vocabulary_filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.filter.delete vocabulary_filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_vocabulary_filter",
        op_kwargs={"VocabularyFilterName": vocabulary_filter_name},
    )


async def get(hub, ctx, vocabulary_filter_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a vocabulary filter.

    Args:
        vocabulary_filter_name(str): The name of the vocabulary filter for which to return information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.filter_.get(
                ctx, vocabulary_filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.filter.get vocabulary_filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="get_vocabulary_filter",
        op_kwargs={"VocabularyFilterName": vocabulary_filter_name},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, name_contains: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about vocabulary filters.

    Args:
        next_token(str, optional): If the result of the previous request to ListVocabularyFilters was truncated, include the NextToken to fetch the next set of collections. Defaults to None.
        max_results(int, optional): The maximum number of filters to return in the response. If there are fewer results in the list, this response contains only the actual results. Defaults to None.
        name_contains(str, optional): Filters the response so that it only contains vocabulary filters whose name contains the specified string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.filter_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.filter.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_vocabulary_filters",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
        },
    )


async def update(
    hub,
    ctx,
    vocabulary_filter_name: str,
    words: List = None,
    vocabulary_filter_file_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a vocabulary filter with a new list of filtered words.

    Args:
        vocabulary_filter_name(str): The name of the vocabulary filter to update. If you try to update a vocabulary filter with the same name as another vocabulary filter, you get a ConflictException error.
        words(List, optional): The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see Character Sets for Custom Vocabularies. If you provide a list of words in the Words parameter, you can't use the VocabularyFilterFileUri parameter. Defaults to None.
        vocabulary_filter_file_uri(str, optional): The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see Character Sets for Custom Vocabularies. The specified file must be less than 50 KB of UTF-8 characters. If you provide the location of a list of words in the VocabularyFilterFileUri parameter, you can't use the Words parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.vocabulary.filter_.update(
                ctx, vocabulary_filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.vocabulary.filter.update vocabulary_filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="update_vocabulary_filter",
        op_kwargs={
            "VocabularyFilterName": vocabulary_filter_name,
            "Words": words,
            "VocabularyFilterFileUri": vocabulary_filter_file_uri,
        },
    )
