"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, transcription_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.

    Args:
        transcription_job_name(str): The name of the transcription job to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.transcription_job.delete(
                ctx, transcription_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.transcription_job.delete transcription_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_transcription_job",
        op_kwargs={"TranscriptionJobName": transcription_job_name},
    )


async def get(hub, ctx, transcription_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a transcription job. To see the status of the job, check the TranscriptionJobStatus field. If the status is COMPLETED, the job is finished and you can find the results at the location specified in the TranscriptFileUri field. If you enable content redaction, the redacted transcript appears in RedactedTranscriptFileUri.

    Args:
        transcription_job_name(str): The name of the job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.transcription_job.get(
                ctx, transcription_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.transcription_job.get transcription_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="get_transcription_job",
        op_kwargs={"TranscriptionJobName": transcription_job_name},
    )


async def list_all(
    hub,
    ctx,
    status: str = None,
    job_name_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists transcription jobs with the specified status.

    Args:
        status(str, optional): When specified, returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don’t specify a status, Amazon Transcribe returns all transcription jobs ordered by creation date. . Defaults to None.
        job_name_contains(str, optional): When specified, the jobs returned in the list are limited to jobs whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the result of the previous request to ListTranscriptionJobs was truncated, include the NextToken to fetch the next set of jobs. Defaults to None.
        max_results(int, optional): The maximum number of jobs to return in the response. If there are fewer results in the list, this response contains only the actual results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.transcription_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.transcription_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_transcription_jobs",
        op_kwargs={
            "Status": status,
            "JobNameContains": job_name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    transcription_job_name: str,
    media: Dict,
    language_code: str = None,
    media_sample_rate_hertz: int = None,
    media_format: str = None,
    output_bucket_name: str = None,
    output_key: str = None,
    output_encryption_kms_key_id: str = None,
    settings: Dict = None,
    model_settings: Dict = None,
    job_execution_settings: Dict = None,
    content_redaction: Dict = None,
    identify_language: bool = None,
    language_options: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous job to transcribe speech to text.

    Args:
        transcription_job_name(str): The name of the job. You can't use the strings "." or ".." by themselves as the job name. The name must also be unique within an AWS account. If you try to create a transcription job with the same name as a previous transcription job, you get a ConflictException error.
        language_code(str, optional): The language code for the language used in the input media file. To transcribe speech in Modern Standard Arabic (ar-SA), your audio or video file must be encoded at a sample rate of 16000 Hz or higher. Defaults to None.
        media_sample_rate_hertz(int, optional): The sample rate, in Hertz, of the audio track in the input media file.  If you do not specify the media sample rate, Amazon Transcribe determines the sample rate. If you specify the sample rate, it must match the sample rate detected by Amazon Transcribe. In most cases, you should leave the MediaSampleRateHertz field blank and let Amazon Transcribe determine the sample rate. Defaults to None.
        media_format(str, optional): The format of the input media file. Defaults to None.
        media(Dict): An object that describes the input media for a transcription job.
        output_bucket_name(str, optional): The location where the transcription is stored. If you set the OutputBucketName, Amazon Transcribe puts the transcript in the specified S3 bucket. When you call the GetTranscriptionJob operation, the operation returns this location in the TranscriptFileUri field. If you enable content redaction, the redacted transcript appears in RedactedTranscriptFileUri. If you enable content redaction and choose to output an unredacted transcript, that transcript's location still appears in the TranscriptFileUri. The S3 bucket must have permissions that allow Amazon Transcribe to put files in the bucket. For more information, see Permissions Required for IAM User Roles. You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the OutputEncryptionKMSKeyId parameter. If you don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket. If you don't set the OutputBucketName, Amazon Transcribe generates a pre-signed URL, a shareable URL that provides secure access to your transcription, and returns it in the TranscriptFileUri field. Use this URL to download the transcription. Defaults to None.
        output_key(str, optional): You can specify a location in an Amazon S3 bucket to store the output of your transcription job. If you don't specify an output key, Amazon Transcribe stores the output of your transcription job in the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json". You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You can use an output key to change both the prefix and the file name, for example "folder/my-other-job-name.json". If you specify an output key, you must also specify an S3 bucket in the OutputBucketName parameter. Defaults to None.
        output_encryption_kms_key_id(str, optional): The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the StartTranscriptionJob operation must have permission to use the specified KMS key. You can use either of the following to identify a KMS key in the current account:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"   KMS Key Alias: "alias/ExampleAlias"   You can use either of the following to identify a KMS key in the current account or another account:   Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"   ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"   If you don't specify an encryption key, the output of the transcription job is encrypted with the default Amazon S3 key (SSE-S3).  If you specify a KMS key to encrypt your output, you must also specify an output location in the OutputBucketName parameter. Defaults to None.
        settings(Dict, optional): A Settings object that provides optional settings for a transcription job. Defaults to None.
        model_settings(Dict, optional): Choose the custom language model you use for your transcription job in this parameter. Defaults to None.
        job_execution_settings(Dict, optional): Provides information about how a transcription job is executed. Use this field to indicate that the job can be queued for deferred execution if the concurrency limit is reached and there are no slots available to immediately run the job. Defaults to None.
        content_redaction(Dict, optional): An object that contains the request parameters for content redaction. Defaults to None.
        identify_language(bool, optional): Set this field to true to enable automatic language identification. Automatic language identification is disabled by default. You receive a BadRequestException error if you enter a value for a LanguageCode. Defaults to None.
        language_options(List, optional): An object containing a list of languages that might be present in your collection of audio files. Automatic language identification chooses a language that best matches the source audio from that list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.transcription_job.start(
                ctx, transcription_job_name=value, media=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.transcription_job.start transcription_job_name=value, media=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="start_transcription_job",
        op_kwargs={
            "TranscriptionJobName": transcription_job_name,
            "LanguageCode": language_code,
            "MediaSampleRateHertz": media_sample_rate_hertz,
            "MediaFormat": media_format,
            "Media": media,
            "OutputBucketName": output_bucket_name,
            "OutputKey": output_key,
            "OutputEncryptionKMSKeyId": output_encryption_kms_key_id,
            "Settings": settings,
            "ModelSettings": model_settings,
            "JobExecutionSettings": job_execution_settings,
            "ContentRedaction": content_redaction,
            "IdentifyLanguage": identify_language,
            "LanguageOptions": language_options,
        },
    )
