"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, vocabulary_name: str, language_code: str, vocabulary_file_uri: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom vocabulary that you can use to change how Amazon Transcribe Medical transcribes your audio file.

    Args:
        vocabulary_name(str): The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If you try to create a vocabulary with the same name as a previous vocabulary, you get a ConflictException error.
        language_code(str): The language code for the language used for the entries in your custom vocabulary. The language code of your custom vocabulary must match the language code of your transcription job. US English (en-US) is the only language code available for Amazon Transcribe Medical.
        vocabulary_file_uri(str): The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in the same AWS Region as the resource that you're calling. Enter information about your VocabularyFileUri in the following format:   https://s3.<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>   The following is an example URI for a vocabulary file that is stored in Amazon S3:  https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt  For more information about Amazon S3 object names, see Object Keys in the Amazon S3 Developer Guide. For more information about custom vocabularies, see Medical Custom Vocabularies.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.vocabulary.create(
                ctx, vocabulary_name=value, language_code=value, vocabulary_file_uri=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.vocabulary.create vocabulary_name=value, language_code=value, vocabulary_file_uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="create_medical_vocabulary",
        op_kwargs={
            "VocabularyName": vocabulary_name,
            "LanguageCode": language_code,
            "VocabularyFileUri": vocabulary_file_uri,
        },
    )


async def delete(hub, ctx, vocabulary_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a vocabulary from Amazon Transcribe Medical.

    Args:
        vocabulary_name(str): The name of the vocabulary that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.vocabulary.delete(ctx, vocabulary_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.vocabulary.delete vocabulary_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_medical_vocabulary",
        op_kwargs={"VocabularyName": vocabulary_name},
    )


async def get(hub, ctx, vocabulary_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a medical vocabulary.

    Args:
        vocabulary_name(str): The name of the vocabulary that you want information about. The value is case sensitive. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.vocabulary.get(ctx, vocabulary_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.vocabulary.get vocabulary_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="get_medical_vocabulary",
        op_kwargs={"VocabularyName": vocabulary_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    state_equals: str = None,
    name_contains: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of vocabularies that match the specified criteria. If you don't enter a value in any of the request parameters, returns the entire list of vocabularies.

    Args:
        next_token(str, optional): If the result of your previous request to ListMedicalVocabularies was truncated, include the NextToken to fetch the next set of vocabularies. Defaults to None.
        max_results(int, optional): The maximum number of vocabularies to return in the response. Defaults to None.
        state_equals(str, optional): When specified, returns only vocabularies with the VocabularyState equal to the specified vocabulary state. Use this field to see which vocabularies are ready for your medical transcription jobs. Defaults to None.
        name_contains(str, optional): Returns vocabularies whose names contain the specified string. The search is not case sensitive. ListMedicalVocabularies returns both "vocabularyname" and "VocabularyName". Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.vocabulary.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.vocabulary.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_medical_vocabularies",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "StateEquals": state_equals,
            "NameContains": name_contains,
        },
    )


async def update(
    hub, ctx, vocabulary_name: str, language_code: str, vocabulary_file_uri: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a vocabulary with new values that you provide in a different text file from the one you used to create the vocabulary. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.

    Args:
        vocabulary_name(str): The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a vocabulary you've already made, you get a ConflictException error.
        language_code(str): The language code of the language used for the entries in the updated vocabulary. US English (en-US) is the only valid language code in Amazon Transcribe Medical.
        vocabulary_file_uri(str, optional): The location in Amazon S3 of the text file that contains the you use for your custom vocabulary. The URI must be in the same AWS Region as the resource that you are calling. The following is the format for a URI:   https://s3.<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>   For example:  https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt  For more information about Amazon S3 object names, see Object Keys in the Amazon S3 Developer Guide. For more information about custom vocabularies in Amazon Transcribe Medical, see Medical Custom Vocabularies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.vocabulary.update(
                ctx, vocabulary_name=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.vocabulary.update vocabulary_name=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="update_medical_vocabulary",
        op_kwargs={
            "VocabularyName": vocabulary_name,
            "LanguageCode": language_code,
            "VocabularyFileUri": vocabulary_file_uri,
        },
    )
