"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, medical_transcription_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a transcription job generated by Amazon Transcribe Medical and any related information.

    Args:
        medical_transcription_job_name(str): The name you provide to the DeleteMedicalTranscriptionJob object to delete a transcription job.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.transcription_job.delete(
                ctx, medical_transcription_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.transcription_job.delete medical_transcription_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_medical_transcription_job",
        op_kwargs={"MedicalTranscriptionJobName": medical_transcription_job_name},
    )


async def get(hub, ctx, medical_transcription_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a transcription job from Amazon Transcribe Medical. To see the status of the job, check the TranscriptionJobStatus field. If the status is COMPLETED, the job is finished. You find the results of the completed job in the TranscriptFileUri field.

    Args:
        medical_transcription_job_name(str): The name of the medical transcription job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.transcription_job.get(
                ctx, medical_transcription_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.transcription_job.get medical_transcription_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="get_medical_transcription_job",
        op_kwargs={"MedicalTranscriptionJobName": medical_transcription_job_name},
    )


async def list_all(
    hub,
    ctx,
    status: str = None,
    job_name_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists medical transcription jobs with a specified status or substring that matches their names.

    Args:
        status(str, optional): When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe Medical returns all transcription jobs ordered by creation date. Defaults to None.
        job_name_contains(str, optional): When specified, the jobs returned in the list are limited to jobs whose name contains the specified string. Defaults to None.
        next_token(str, optional): If you a receive a truncated result in the previous request of ListMedicalTranscriptionJobs, include NextToken to fetch the next set of jobs. Defaults to None.
        max_results(int, optional): The maximum number of medical transcription jobs to return in the response. IF there are fewer results in the list, this response contains only the actual results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.transcription_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.transcription_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_medical_transcription_jobs",
        op_kwargs={
            "Status": status,
            "JobNameContains": job_name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    medical_transcription_job_name: str,
    language_code: str,
    media: Dict,
    output_bucket_name: str,
    specialty: str,
    type_: str,
    media_sample_rate_hertz: int = None,
    media_format: str = None,
    output_key: str = None,
    output_encryption_kms_key_id: str = None,
    settings: Dict = None,
    content_identification_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a batch job to transcribe medical speech to text.

    Args:
        medical_transcription_job_name(str): The name of the medical transcription job. You can't use the strings "." or ".." by themselves as the job name. The name must also be unique within an AWS account. If you try to create a medical transcription job with the same name as a previous medical transcription job, you get a ConflictException error.
        language_code(str): The language code for the language spoken in the input media file. US English (en-US) is the valid value for medical transcription jobs. Any other value you enter for language code results in a BadRequestException error.
        media_sample_rate_hertz(int, optional): The sample rate, in Hertz, of the audio track in the input media file. If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave the MediaSampleRateHertz field blank and let Amazon Transcribe Medical determine the sample rate. Defaults to None.
        media_format(str, optional): The audio format of the input media file. Defaults to None.
        media(Dict): Describes the input media file in a transcription request.
        output_bucket_name(str): The Amazon S3 location where the transcription is stored. You must set OutputBucketName for Amazon Transcribe Medical to store the transcription results. Your transcript appears in the S3 location you specify. When you call the GetMedicalTranscriptionJob, the operation returns this location in the TranscriptFileUri field. The S3 bucket must have permissions that allow Amazon Transcribe Medical to put files in the bucket. For more information, see Permissions Required for IAM User Roles. You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the OutputEncryptionKMSKeyId parameter. If you don't specify a KMS key, Amazon Transcribe Medical uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.
        output_key(str, optional): You can specify a location in an Amazon S3 bucket to store the output of your medical transcription job. If you don't specify an output key, Amazon Transcribe Medical stores the output of your transcription job in the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json". You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You can use an output key to change both the prefix and the file name, for example "folder/my-other-job-name.json". If you specify an output key, you must also specify an S3 bucket in the OutputBucketName parameter. Defaults to None.
        output_encryption_kms_key_id(str, optional): The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the StartMedicalTranscriptionJob operation must have permission to use the specified KMS key. You use either of the following to identify a KMS key in the current account:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"   KMS Key Alias: "alias/ExampleAlias"   You can use either of the following to identify a KMS key in the current account or another account:   Amazon Resource Name (ARN) of a KMS key in the current account or another account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"   ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"   If you don't specify an encryption key, the output of the medical transcription job is encrypted with the default Amazon S3 key (SSE-S3). If you specify a KMS key to encrypt your output, you must also specify an output location in the OutputBucketName parameter. Defaults to None.
        settings(Dict, optional): Optional settings for the medical transcription job. Defaults to None.
        content_identification_type(str, optional): You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify PHI, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies in the transcription output. Defaults to None.
        specialty(str): The medical specialty of any clinician speaking in the input media.
        type_(str): The type of speech in the input audio. CONVERSATION refers to conversations between two or more speakers, e.g., a conversations between doctors and patients. DICTATION refers to single-speaker dictated speech, e.g., for clinical notes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.medical.transcription_job.start(
                ctx,
                medical_transcription_job_name=value,
                language_code=value,
                media=value,
                output_bucket_name=value,
                specialty=value,
                type_=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.medical.transcription_job.start medical_transcription_job_name=value, language_code=value, media=value, output_bucket_name=value, specialty=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="start_medical_transcription_job",
        op_kwargs={
            "MedicalTranscriptionJobName": medical_transcription_job_name,
            "LanguageCode": language_code,
            "MediaSampleRateHertz": media_sample_rate_hertz,
            "MediaFormat": media_format,
            "Media": media,
            "OutputBucketName": output_bucket_name,
            "OutputKey": output_key,
            "OutputEncryptionKMSKeyId": output_encryption_kms_key_id,
            "Settings": settings,
            "ContentIdentificationType": content_identification_type,
            "Specialty": specialty,
            "Type": type_,
        },
    )
