"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    language_code: str,
    base_model_name: str,
    model_name: str,
    input_data_config: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom language model. Use Amazon S3 prefixes to provide the location of your input files. The time it takes to create your model depends on the size of your training data.

    Args:
        language_code(str): The language of the input text you're using to train your custom language model.
        base_model_name(str): The Amazon Transcribe standard language model, or base model used to create your custom language model. If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater, choose Wideband. If you want to use your custom language model to transcribe audio with a sample rate that is less than 16 kHz, choose Narrowband.
        model_name(str): The name you choose for your custom language model when you create it.
        input_data_config(Dict): Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom language model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.language_model.create(
                ctx,
                language_code=value,
                base_model_name=value,
                model_name=value,
                input_data_config=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.language_model.create language_code=value, base_model_name=value, model_name=value, input_data_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="create_language_model",
        op_kwargs={
            "LanguageCode": language_code,
            "BaseModelName": base_model_name,
            "ModelName": model_name,
            "InputDataConfig": input_data_config,
        },
    )


async def delete(hub, ctx, model_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a custom language model using its name.

    Args:
        model_name(str): The name of the model you're choosing to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.language_model.delete(ctx, model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.language_model.delete model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="delete_language_model",
        op_kwargs={"ModelName": model_name},
    )


async def describe(hub, ctx, model_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a single custom language model. Use this information to see details about the language model in your AWS account. You can also see whether the base language model used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model. If the language model wasn't created, you can use this operation to understand why Amazon Transcribe couldn't create it.

    Args:
        model_name(str): The name of the custom language model you submit to get more information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.language_model.describe(ctx, model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.language_model.describe model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="describe_language_model",
        op_kwargs={"ModelName": model_name},
    )


async def list_all(
    hub,
    ctx,
    status_equals: str = None,
    name_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides more information about the custom language models you've created. You can use the information in this list to find a specific custom language model. You can then use the operation to get more information about it.

    Args:
        status_equals(str, optional): When specified, returns only custom language models with the specified status. Language models are ordered by creation date, with the newest models first. If you don't specify a status, Amazon Transcribe returns all custom language models ordered by date. Defaults to None.
        name_contains(str, optional): When specified, the custom language model names returned contain the substring you've specified. Defaults to None.
        next_token(str, optional): When included, fetches the next set of jobs if the result of the previous request was truncated. Defaults to None.
        max_results(int, optional): The maximum number of language models to return in the response. If there are fewer results in the list, the response contains only the actual results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.transcribe.language_model.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.transcribe.language_model.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="transcribe",
        operation="list_language_models",
        op_kwargs={
            "StatusEquals": status_equals,
            "NameContains": name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
