"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    retention_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The CreateTable operation adds a new table to an existing database in your account. In an AWS account, table names must be at least unique within each Region if they are in the same database. You may have identical table names in the same Region if the tables are in seperate databases. While creating the table, you must specify the table name, database name, and the retention properties. Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        database_name(str): The name of the Timestream database.
        table_name(str): The name of the Timestream table.
        retention_properties(Dict, optional): The duration for which your time series data must be stored in the memory store and the magnetic store. Defaults to None.
        tags(List, optional):  A list of key-value pairs to label the table. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.table.create(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.table.create database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="create_table",
        op_kwargs={
            "DatabaseName": database_name,
            "TableName": table_name,
            "RetentionProperties": retention_properties,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, database_name: str, table_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is deleted, the time series data stored in the table cannot be recovered.  Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.

    Args:
        database_name(str): The name of the database where the Timestream database is to be deleted.
        table_name(str): The name of the Timestream table to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.table.delete(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.table.delete database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="delete_table",
        op_kwargs={"DatabaseName": database_name, "TableName": table_name},
    )


async def describe(hub, ctx, database_name: str, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the table, including the table name, database name, retention duration of the memory store and the magnetic store. Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        database_name(str): The name of the Timestream database.
        table_name(str): The name of the Timestream table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.table.describe(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.table.describe database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="describe_table",
        op_kwargs={"DatabaseName": database_name, "TableName": table_name},
    )


async def list_all(
    hub, ctx, database_name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    A list of tables, along with the name, status and retention properties of each table.

    Args:
        database_name(str, optional): The name of the Timestream database. Defaults to None.
        next_token(str, optional): The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation. Defaults to None.
        max_results(int, optional): The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.table.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.table.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="list_tables",
        op_kwargs={
            "DatabaseName": database_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, database_name: str, table_name: str, retention_properties: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store.  Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        database_name(str): The name of the Timestream database.
        table_name(str): The name of the Timesream table.
        retention_properties(Dict): The retention duration of the memory store and the magnetic store.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.table.update(
                ctx, database_name=value, table_name=value, retention_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.table.update database_name=value, table_name=value, retention_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="update_table",
        op_kwargs={
            "DatabaseName": database_name,
            "TableName": table_name,
            "RetentionProperties": retention_properties,
        },
    )
