"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, database_name: str, kms_key_id: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to AWS managed KMS keys for more info. Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        database_name(str): The name of the Timestream database.
        kms_key_id(str, optional): The KMS key for the database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to AWS managed KMS keys for more info. Defaults to None.
        tags(List, optional):  A list of key-value pairs to label the table. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.database.create(ctx, database_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.database.create database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="create_database",
        op_kwargs={"DatabaseName": database_name, "KmsKeyId": kms_key_id, "Tags": tags},
    )


async def delete(hub, ctx, database_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a given Timestream database. This is an irreversible operation. After a database is deleted, the time series data from its tables cannot be recovered.  All tables in the database must be deleted first, or a ValidationException error will be thrown.  Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.

    Args:
        database_name(str): The name of the Timestream database to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.database.delete(ctx, database_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.database.delete database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="delete_database",
        op_kwargs={"DatabaseName": database_name},
    )


async def describe(hub, ctx, database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the database, including the database name, time that the database was created, and the total number of tables found within the database. Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        database_name(str): The name of the Timestream database.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.database.describe(ctx, database_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.database.describe database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="describe_database",
        op_kwargs={"DatabaseName": database_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of your Timestream databases. Service quotas apply. For more information, see Access Management in the Timestream Developer Guide.

    Args:
        next_token(str, optional): The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation. Defaults to None.
        max_results(int, optional): The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.database.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.database.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="list_databases",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(hub, ctx, database_name: str, kms_key_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Modifies the KMS key for an existing database. While updating the database, you must specify the database name and the identifier of the new KMS key to be used (KmsKeyId). If there are any concurrent UpdateDatabase requests, first writer wins.

    Args:
        database_name(str):  The name of the database. .
        kms_key_id(str):  The identifier of the new KMS key (KmsKeyId) to be used to encrypt the data stored in the database. If the KmsKeyId currently registered with the database is the same as the KmsKeyId in the request, there will not be any update.  You can specify the KmsKeyId using any of the following:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    Alias name: alias/ExampleAlias    Alias ARN: arn:aws:kms:us-east-1:111122223333:alias/ExampleAlias   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_write.database.update(
                ctx, database_name=value, kms_key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_write.database.update database_name=value, kms_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-write",
        operation="update_database",
        op_kwargs={"DatabaseName": database_name, "KmsKeyId": kms_key_id},
    )
