"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, query_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Cancels a query that has been issued. Cancellation is guaranteed only if the query has not completed execution before the cancellation request was issued. Because cancellation is an idempotent operation, subsequent cancellation requests will return a CancellationMessage, indicating that the query has already been canceled.

    Args:
        query_id(str):  The id of the query that needs to be cancelled. QueryID is returned as part of QueryResult. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_query.query.cancel(ctx, query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_query.query.cancel query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-query",
        operation="cancel_query",
        op_kwargs={"QueryId": query_id},
    )
