"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def query(
    hub,
    ctx,
    query_string: str,
    client_token: str = None,
    next_token: str = None,
    max_rows: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Query is a synchronous operation that enables you to execute a query. Query will timeout after 60 seconds. You must update the default timeout in the SDK to support a timeout of 60 seconds. The result set will be truncated to 1MB. Service quotas apply. For more information, see Quotas in the Timestream Developer Guide.

    Args:
        query_string(str):  The query to be executed by Timestream. .
        client_token(str, optional):  Unique, case-sensitive string of up to 64 ASCII characters that you specify when you make a Query request. Providing a ClientToken makes the call to Query idempotent, meaning that multiple identical calls have the same effect as one single call.  Your query request will fail in the following cases:    If you submit a request with the same client token outside the 5-minute idepotency window.     If you submit a request with the same client token but a change in other parameters within the 5-minute idempotency window.     After 4 hours, any request with the same client token is treated as a new request. . Defaults to None.
        next_token(str, optional):  A pagination token passed to get a set of results. . Defaults to None.
        max_rows(int, optional):  The total number of rows to return in the output. If the total number of rows available is more than the value specified, a NextToken is provided in the command's output. To resume pagination, provide the NextToken value in the starting-token argument of a subsequent command. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.timestream_query.init.query(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.timestream_query.init.query query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="timestream-query",
        operation="query",
        op_kwargs={
            "QueryString": query_string,
            "ClientToken": client_token,
            "NextToken": next_token,
            "MaxRows": max_rows,
        },
    )
