"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Synthetics canary runtime versions. For more information, see  Canary Runtime Versions.

    Args:
        next_token(str, optional): A token that indicates that there is more data available. You can use this token in a subsequent DescribeRuntimeVersions operation to retrieve the next set of results. Defaults to None.
        max_results(int, optional): Specify this parameter to limit how many runs are returned each time you use the DescribeRuntimeVersions operation. If you omit this parameter, the default of 100 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.runtime_version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.runtime_version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="describe_runtime_versions",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
