"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to see information from the most recent run of each canary that you have created.

    Args:
        next_token(str, optional): A token that indicates that there is more data available. You can use this token in a subsequent DescribeCanaries operation to retrieve the next set of results. Defaults to None.
        max_results(int, optional): Specify this parameter to limit how many runs are returned each time you use the DescribeLastRun operation. If you omit this parameter, the default of 100 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.last_run.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.last_run.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="describe_canaries_last_run",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
