"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    code: Dict,
    artifact_s3_location: str,
    execution_role_arn: str,
    schedule: Dict,
    runtime_version: str,
    run_config: Dict = None,
    success_retention_period_in_days: int = None,
    failure_retention_period_in_days: int = None,
    vpc_config: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a canary. Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.  Do not use CreateCanary to modify an existing canary. Use UpdateCanary instead. To create canaries, you must have the CloudWatchSyntheticsFullAccess policy. If you are creating a new IAM role for the canary, you also need the the iam:CreateRole, iam:CreatePolicy and iam:AttachRolePolicy permissions. For more information, see Necessary Roles and Permissions. Do not include secrets or proprietary information in your canary names. The canary name makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in outbound calls over the internet. For more information, see Security Considerations for Synthetics Canaries.

    Args:
        name(str): The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries in your account. Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see Security Considerations for Synthetics Canaries.
        code(Dict): A structure that includes the entry point from which the canary should start running your script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. .
        artifact_s3_location(str): The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts include the log file, screenshots, and HAR files. The name of the S3 bucket can't include a period (.).
        execution_role_arn(str): The ARN of the IAM role to be used to run the canary. This role must already exist, and must include lambda.amazonaws.com as a principal in the trust policy. The role must also have the following permissions:    s3:PutObject     s3:GetBucketLocation     s3:ListAllMyBuckets     cloudwatch:PutMetricData     logs:CreateLogGroup     logs:CreateLogStream     logs:PutLogEvents   .
        schedule(Dict): A structure that contains information about how often the canary is to run and when these test runs are to stop.
        run_config(Dict, optional): A structure that contains the configuration for individual canary runs, such as timeout value. Defaults to None.
        success_retention_period_in_days(int, optional): The number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days. Defaults to None.
        failure_retention_period_in_days(int, optional): The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days. Defaults to None.
        runtime_version(str): Specifies the runtime version to use for the canary. For a list of valid runtime versions and more information about runtime versions, see  Canary Runtime Versions.
        vpc_config(Dict, optional): If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. For more information, see  Running a Canary in a VPC. Defaults to None.
        tags(Dict, optional): A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a canary. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.create(
                ctx,
                name=value,
                code=value,
                artifact_s3_location=value,
                execution_role_arn=value,
                schedule=value,
                runtime_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.create name=value, code=value, artifact_s3_location=value, execution_role_arn=value, schedule=value, runtime_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="create_canary",
        op_kwargs={
            "Name": name,
            "Code": code,
            "ArtifactS3Location": artifact_s3_location,
            "ExecutionRoleArn": execution_role_arn,
            "Schedule": schedule,
            "RunConfig": run_config,
            "SuccessRetentionPeriodInDays": success_retention_period_in_days,
            "FailureRetentionPeriodInDays": failure_retention_period_in_days,
            "RuntimeVersion": runtime_version,
            "VpcConfig": vpc_config,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently deletes the specified canary. When you delete a canary, resources used and created by the canary are not automatically deleted. After you delete a canary that you do not intend to use again, you should also delete the following:   The Lambda functions and layers used by this canary. These have the prefix cwsyn-MyCanaryName .   The CloudWatch alarms created for this canary. These alarms have a name of Synthetics-SharpDrop-Alarm-MyCanaryName .   Amazon S3 objects and buckets, such as the canary's artifact location.   IAM roles created for the canary. If they were created in the console, these roles have the name  role/service-role/CloudWatchSyntheticsRole-MyCanaryName .   CloudWatch Logs log groups created for the canary. These logs groups have the name /aws/lambda/cwsyn-MyCanaryName .    Before you delete a canary, you might want to use GetCanary to display the information about this canary. Make note of the information returned by this operation so that you can delete these resources after you delete the canary.

    Args:
        name(str): The name of the canary that you want to delete. To find the names of your canaries, use DescribeCanaries.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="delete_canary",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns a list of the canaries in your account, along with full details about each canary. This operation does not have resource-level authorization, so if a user is able to use DescribeCanaries, the user can see all of the canaries in the account. A deny policy can only be used to restrict access to all canaries. It cannot be used on specific resources.

    Args:
        next_token(str, optional): A token that indicates that there is more data available. You can use this token in a subsequent operation to retrieve the next set of results. Defaults to None.
        max_results(int, optional): Specify this parameter to limit how many canaries are returned each time you use the DescribeCanaries operation. If you omit this parameter, the default of 100 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="describe_canaries",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves complete information about one canary. You must specify the name of the canary that you want. To get a list of canaries and their names, use DescribeCanaries.

    Args:
        name(str): The name of the canary that you want details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="synthetics", operation="get_canary", op_kwargs={"Name": name}
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to run a canary that has already been created. The frequency of the canary runs is determined by the value of the canary's Schedule. To see a canary's schedule, use GetCanary.

    Args:
        name(str): The name of the canary that you want to run. To find canary names, use DescribeCanaries.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="start_canary",
        op_kwargs={"Name": name},
    )


async def stop(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the canary to prevent all future runs. If the canary is currently running, Synthetics stops waiting for the current run of the specified canary to complete. The run that is in progress completes on its own, publishes metrics, and uploads artifacts, but it is not recorded in Synthetics as a completed run. You can use StartCanary to start it running again with the canary’s current schedule at any point in the future.

    Args:
        name(str): The name of the canary that you want to stop. To find the names of your canaries, use DescribeCanaries.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.stop(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.stop name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="stop_canary",
        op_kwargs={"Name": name},
    )


async def update(
    hub,
    ctx,
    name: str,
    code: Dict = None,
    execution_role_arn: str = None,
    runtime_version: str = None,
    schedule: Dict = None,
    run_config: Dict = None,
    success_retention_period_in_days: int = None,
    failure_retention_period_in_days: int = None,
    vpc_config: Dict = None,
    visual_reference: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to change the settings of a canary that has already been created. You can't use this operation to update the tags of an existing canary. To change the tags of an existing canary, use TagResource.

    Args:
        name(str): The name of the canary that you want to update. To find the names of your canaries, use DescribeCanaries. You cannot change the name of a canary that has already been created.
        code(Dict, optional): A structure that includes the entry point from which the canary should start running your script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. . Defaults to None.
        execution_role_arn(str, optional): The ARN of the IAM role to be used to run the canary. This role must already exist, and must include lambda.amazonaws.com as a principal in the trust policy. The role must also have the following permissions:    s3:PutObject     s3:GetBucketLocation     s3:ListAllMyBuckets     cloudwatch:PutMetricData     logs:CreateLogGroup     logs:CreateLogStream     logs:CreateLogStream   . Defaults to None.
        runtime_version(str, optional): Specifies the runtime version to use for the canary. For a list of valid runtime versions and for more information about runtime versions, see  Canary Runtime Versions. Defaults to None.
        schedule(Dict, optional): A structure that contains information about how often the canary is to run, and when these runs are to stop. Defaults to None.
        run_config(Dict, optional): A structure that contains the timeout value that is used for each individual run of the canary. Defaults to None.
        success_retention_period_in_days(int, optional): The number of days to retain data about successful runs of this canary. Defaults to None.
        failure_retention_period_in_days(int, optional): The number of days to retain data about failed runs of this canary. Defaults to None.
        vpc_config(Dict, optional): If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. For more information, see  Running a Canary in a VPC. Defaults to None.
        visual_reference(Dict, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.synthetic.canary.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.synthetic.canary.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="synthetics",
        operation="update_canary",
        op_kwargs={
            "Name": name,
            "Code": code,
            "ExecutionRoleArn": execution_role_arn,
            "RuntimeVersion": runtime_version,
            "Schedule": schedule,
            "RunConfig": run_config,
            "SuccessRetentionPeriodInDays": success_retention_period_in_days,
            "FailureRetentionPeriodInDays": failure_retention_period_in_days,
            "VpcConfig": vpc_config,
            "VisualReference": visual_reference,
        },
    )
