"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def deprecate(hub, ctx, domain: str, workflow_type: Dict) -> None:
    r"""
    **Autogenerated function**

    Deprecates the specified workflow type. After a workflow type has been deprecated, you cannot create new executions of that type. Executions that were started before the type was deprecated continues to run. A deprecated workflow type may still be used when calling visibility actions.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    workflowType.name: String constraint. The key is swf:workflowType.name.    workflowType.version: String constraint. The key is swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the workflow type is registered.
        workflow_type(Dict): The workflow type to deprecate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.type_.deprecate(
                ctx, domain=value, workflow_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.type.deprecate domain=value, workflow_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="deprecate_workflow_type",
        op_kwargs={"domain": domain, "workflowType": workflow_type},
    )


async def describe(hub, ctx, domain: str, workflow_type: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified workflow type. This includes configuration settings specified when the type was registered and other information such as creation date, current status, etc.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    workflowType.name: String constraint. The key is swf:workflowType.name.    workflowType.version: String constraint. The key is swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which this workflow type is registered.
        workflow_type(Dict): The workflow type to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.type_.describe(
                ctx, domain=value, workflow_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.type.describe domain=value, workflow_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="describe_workflow_type",
        op_kwargs={"domain": domain, "workflowType": workflow_type},
    )


async def list_all(
    hub,
    ctx,
    domain: str,
    registration_status: str,
    name: str = None,
    next_page_token: str = None,
    maximum_page_size: int = None,
    reverse_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about workflow types in the specified domain. The results may be split into multiple pages that can be retrieved by making the call repeatedly.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the workflow types have been registered.
        name(str, optional): If specified, lists the workflow type with this name. Defaults to None.
        registration_status(str): Specifies the registration status of the workflow types to list.
        next_page_token(str, optional): If NextPageToken is returned there are more results available. The value of NextPageToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has exceeded its maximum lifetime".  The configured maximumPageSize determines how many results can be returned in a single call. . Defaults to None.
        maximum_page_size(int, optional): The maximum number of results that are returned per call. Use nextPageToken to obtain further pages of results. . Defaults to None.
        reverse_order(bool, optional): When set to true, returns the results in reverse order. By default the results are returned in ascending alphabetical order of the name of the workflow types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.type_.list_all(
                ctx, domain=value, registration_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.type.list_all domain=value, registration_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="list_workflow_types",
        op_kwargs={
            "domain": domain,
            "name": name,
            "registrationStatus": registration_status,
            "nextPageToken": next_page_token,
            "maximumPageSize": maximum_page_size,
            "reverseOrder": reverse_order,
        },
    )


async def register(
    hub,
    ctx,
    domain: str,
    name: str,
    version: str,
    description: str = None,
    default_task_start_to_close_timeout: str = None,
    default_execution_start_to_close_timeout: str = None,
    default_task_list: Dict = None,
    default_task_priority: str = None,
    default_child_policy: str = None,
    default_lambda_role: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Registers a new workflow type and its configuration settings in the specified domain. The retention period for the workflow history is set by the RegisterDomain action.  If the type already exists, then a TypeAlreadyExists fault is returned. You cannot change the configuration settings of a workflow type once it is registered and it must be registered as a new version.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    defaultTaskList.name: String constraint. The key is swf:defaultTaskList.name.    name: String constraint. The key is swf:name.    version: String constraint. The key is swf:version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which to register the workflow type.
        name(str): The name of the workflow type. The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        version(str): The version of the workflow type.  The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the ListWorkflowTypes action.  The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        description(str, optional): Textual description of the workflow type. Defaults to None.
        default_task_start_to_close_timeout(str, optional): If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the StartChildWorkflowExecution Decision. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration. Defaults to None.
        default_execution_start_to_close_timeout(str, optional): If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the StartWorkflowExecution Action or StartChildWorkflowExecution Decision. The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for defaultExecutionStartToCloseTimeout; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out. Defaults to None.
        default_task_list(Dict, optional): If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the StartWorkflowExecution Action or StartChildWorkflowExecution Decision. Defaults to None.
        default_task_priority(str, optional): The default task priority to assign to the workflow type. If not assigned, then 0 is used. Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For more information about setting task priority, see Setting Task Priority in the Amazon SWF Developer Guide. Defaults to None.
        default_child_policy(str, optional): If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the StartChildWorkflowExecution Decision. The supported child policies are:    TERMINATE – The child executions are terminated.    REQUEST_CANCEL – A request to cancel is attempted for each child execution by recording a WorkflowExecutionCancelRequested event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.    ABANDON – No action is taken. The child executions continue to run.  . Defaults to None.
        default_lambda_role(str, optional): The default IAM role attached to this workflow type.  Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html in the Amazon SWF Developer Guide. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.type_.register(
                ctx, domain=value, name=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.type.register domain=value, name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="register_workflow_type",
        op_kwargs={
            "domain": domain,
            "name": name,
            "version": version,
            "description": description,
            "defaultTaskStartToCloseTimeout": default_task_start_to_close_timeout,
            "defaultExecutionStartToCloseTimeout": default_execution_start_to_close_timeout,
            "defaultTaskList": default_task_list,
            "defaultTaskPriority": default_task_priority,
            "defaultChildPolicy": default_child_policy,
            "defaultLambdaRole": default_lambda_role,
        },
    )


async def undeprecate(hub, ctx, domain: str, workflow_type: Dict) -> None:
    r"""
    **Autogenerated function**

    Undeprecates a previously deprecated workflow type. After a workflow type has been undeprecated, you can create new executions of that type.   This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    workflowType.name: String constraint. The key is swf:workflowType.name.    workflowType.version: String constraint. The key is swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain of the deprecated workflow type.
        workflow_type(Dict): The name of the domain of the deprecated workflow type.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.type_.undeprecate(
                ctx, domain=value, workflow_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.type.undeprecate domain=value, workflow_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="undeprecate_workflow_type",
        op_kwargs={"domain": domain, "workflowType": workflow_type},
    )
