"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, domain: str, execution: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified workflow execution including its type and some statistics.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain containing the workflow execution.
        execution(Dict): The workflow execution to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.execution.init.describe(
                ctx, domain=value, execution=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.execution.init.describe domain=value, execution=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="describe_workflow_execution",
        op_kwargs={"domain": domain, "execution": execution},
    )


async def signal(
    hub,
    ctx,
    domain: str,
    workflow_id: str,
    signal_name: str,
    run_id: str = None,
    input_: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Records a WorkflowExecutionSignaled event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).  If a runId isn't specified, then the WorkflowExecutionSignaled event is recorded in the history of the current open workflow with the matching workflowId in the domain.   If the specified workflow execution isn't open, this method fails with UnknownResource.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain containing the workflow execution to signal.
        workflow_id(str): The workflowId of the workflow execution to signal.
        run_id(str, optional): The runId of the workflow execution to signal. Defaults to None.
        signal_name(str): The name of the signal. This name must be meaningful to the target workflow.
        input_(str, optional): Data to attach to the WorkflowExecutionSignaled event in the target workflow execution's history. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.execution.init.signal(
                ctx, domain=value, workflow_id=value, signal_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.execution.init.signal domain=value, workflow_id=value, signal_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="signal_workflow_execution",
        op_kwargs={
            "domain": domain,
            "workflowId": workflow_id,
            "runId": run_id,
            "signalName": signal_name,
            "input": input_,
        },
    )


async def start(
    hub,
    ctx,
    domain: str,
    workflow_id: str,
    workflow_type: Dict,
    task_list: Dict = None,
    task_priority: str = None,
    input_: str = None,
    execution_start_to_close_timeout: str = None,
    tag_list: List = None,
    task_start_to_close_timeout: str = None,
    child_policy: str = None,
    lambda_role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an execution of the workflow type in the specified domain using the provided workflowId and input data. This action returns the newly started workflow execution.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    tagList.member.0: The key is swf:tagList.member.0.    tagList.member.1: The key is swf:tagList.member.1.    tagList.member.2: The key is swf:tagList.member.2.    tagList.member.3: The key is swf:tagList.member.3.    tagList.member.4: The key is swf:tagList.member.4.    taskList: String constraint. The key is swf:taskList.name.    workflowType.name: String constraint. The key is swf:workflowType.name.    workflowType.version: String constraint. The key is swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the workflow execution is created.
        workflow_id(str): The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a restart of a previous execution. You cannot have two open workflow executions with the same workflowId at the same time within the same domain. The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        workflow_type(Dict): The type of the workflow to start.
        task_list(Dict, optional): The task list to use for the decision tasks generated for this workflow execution. This overrides the defaultTaskList specified when registering the workflow type.  A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.  The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn. Defaults to None.
        task_priority(str, optional): The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For more information about setting task priority, see Setting Task Priority in the Amazon SWF Developer Guide. Defaults to None.
        input_(str, optional): The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This input is made available to the new workflow execution in the WorkflowExecutionStarted history event. Defaults to None.
        execution_start_to_close_timeout(str, optional): The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type. The duration is specified in seconds; an integer greater than or equal to 0. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.  An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned. . Defaults to None.
        tag_list(List, optional): The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter. Defaults to None.
        task_start_to_close_timeout(str, optional): Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the defaultTaskStartToCloseTimout specified when registering the workflow type using RegisterWorkflowType. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration.  A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned. . Defaults to None.
        child_policy(str, optional): If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using RegisterWorkflowType. The supported child policies are:    TERMINATE – The child executions are terminated.    REQUEST_CANCEL – A request to cancel is attempted for each child execution by recording a WorkflowExecutionCancelRequested event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.    ABANDON – No action is taken. The child executions continue to run.    A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned. . Defaults to None.
        lambda_role(str, optional): The IAM role to attach to this workflow execution.  Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a ScheduleLambdaFunctionFailed history event. For more information, see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html in the Amazon SWF Developer Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.execution.init.start(
                ctx, domain=value, workflow_id=value, workflow_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.execution.init.start domain=value, workflow_id=value, workflow_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="start_workflow_execution",
        op_kwargs={
            "domain": domain,
            "workflowId": workflow_id,
            "workflowType": workflow_type,
            "taskList": task_list,
            "taskPriority": task_priority,
            "input": input_,
            "executionStartToCloseTimeout": execution_start_to_close_timeout,
            "tagList": tag_list,
            "taskStartToCloseTimeout": task_start_to_close_timeout,
            "childPolicy": child_policy,
            "lambdaRole": lambda_role,
        },
    )


async def terminate(
    hub,
    ctx,
    domain: str,
    workflow_id: str,
    run_id: str = None,
    reason: str = None,
    details: str = None,
    child_policy: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Records a WorkflowExecutionTerminated event and forces closure of the workflow execution identified by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when starting this execution, is applied to any open child workflow executions of this workflow execution.  If the identified workflow execution was in progress, it is terminated immediately.   If a runId isn't specified, then the WorkflowExecutionTerminated event is recorded in the history of the current open workflow with the matching workflowId in the domain.   You should consider using RequestCancelWorkflowExecution action instead because it allows the workflow to gracefully close while TerminateWorkflowExecution doesn't.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The domain of the workflow execution to terminate.
        workflow_id(str): The workflowId of the workflow execution to terminate.
        run_id(str, optional): The runId of the workflow execution to terminate. Defaults to None.
        reason(str, optional):  A descriptive reason for terminating the workflow execution. Defaults to None.
        details(str, optional):  Details for terminating the workflow execution. Defaults to None.
        child_policy(str, optional): If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution. The supported child policies are:    TERMINATE – The child executions are terminated.    REQUEST_CANCEL – A request to cancel is attempted for each child execution by recording a WorkflowExecutionCancelRequested event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.    ABANDON – No action is taken. The child executions continue to run.    A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.execution.init.terminate(
                ctx, domain=value, workflow_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.execution.init.terminate domain=value, workflow_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="terminate_workflow_execution",
        op_kwargs={
            "domain": domain,
            "workflowId": workflow_id,
            "runId": run_id,
            "reason": reason,
            "details": details,
            "childPolicy": child_policy,
        },
    )
