"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    domain: str,
    execution: Dict,
    next_page_token: str = None,
    maximum_page_size: int = None,
    reverse_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the history of the specified workflow execution. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain containing the workflow execution.
        execution(Dict): Specifies the workflow execution for which to return the history.
        next_page_token(str, optional): If NextPageToken is returned there are more results available. The value of NextPageToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has exceeded its maximum lifetime".  The configured maximumPageSize determines how many results can be returned in a single call. . Defaults to None.
        maximum_page_size(int, optional): The maximum number of results that are returned per call. Use nextPageToken to obtain further pages of results. . Defaults to None.
        reverse_order(bool, optional): When set to true, returns the events in reverse order. By default the results are returned in ascending order of the eventTimeStamp of the events. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.workflow.execution.history.get(
                ctx, domain=value, execution=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.workflow.execution.history.get domain=value, execution=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="get_workflow_execution_history",
        op_kwargs={
            "domain": domain,
            "execution": execution,
            "nextPageToken": next_page_token,
            "maximumPageSize": maximum_page_size,
            "reverseOrder": reverse_order,
        },
    )
