"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Add a tag to a Amazon SWF domain.  Amazon SWF supports a maximum of 50 tags per resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the Amazon SWF domain.
        tags(List): The list of tags to add to a domain.  Tags may only contain unicode letters, digits, whitespace, or these symbols: _ . : / = + - @.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="tag_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Remove a tag from a Amazon SWF domain.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the Amazon SWF domain.
        tag_keys(List): The list of tags to remove from the Amazon SWF domain.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="untag_resource",
        op_kwargs={"resourceArn": resource_arn, "tagKeys": tag_keys},
    )
