"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def count(hub, ctx, domain: str, task_list: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then 0 is returned.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the taskList.name parameter by using a Condition element with the swf:taskList.name key to allow the action to access only certain task lists.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain that contains the task list.
        task_list(Dict): The name of the task list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.pending.decision_task.count(
                ctx, domain=value, task_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.pending.decision_task.count domain=value, task_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="count_pending_decision_tasks",
        op_kwargs={"domain": domain, "taskList": task_list},
    )
