"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deprecate(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow executions or register new types. However, you can still use visibility actions on this domain. Deprecating a domain also deprecates all activity and workflow types registered in the domain. Executions that were started before the domain was deprecated continues to run.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        name(str): The name of the domain to deprecate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.domain.deprecate(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.domain.deprecate name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="swf", operation="deprecate_domain", op_kwargs={"name": name}
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified domain, including description and status.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        name(str): The name of the domain to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.domain.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.domain.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="swf", operation="describe_domain", op_kwargs={"name": name}
    )


async def list_all(
    hub,
    ctx,
    registration_status: str,
    next_page_token: str = None,
    maximum_page_size: int = None,
    reverse_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains. The element must be set to arn:aws:swf::AccountID:domain/*, where AccountID is the account ID, with no dashes.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        next_page_token(str, optional): If NextPageToken is returned there are more results available. The value of NextPageToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has exceeded its maximum lifetime".  The configured maximumPageSize determines how many results can be returned in a single call. . Defaults to None.
        registration_status(str): Specifies the registration status of the domains to list.
        maximum_page_size(int, optional): The maximum number of results that are returned per call. Use nextPageToken to obtain further pages of results. . Defaults to None.
        reverse_order(bool, optional): When set to true, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by name of the domains. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.domain.list_all(ctx, registration_status=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.domain.list_all registration_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="list_domains",
        op_kwargs={
            "nextPageToken": next_page_token,
            "registrationStatus": registration_status,
            "maximumPageSize": maximum_page_size,
            "reverseOrder": reverse_order,
        },
    )


async def register(
    hub,
    ctx,
    name: str,
    workflow_execution_retention_period_in_days: str,
    description: str = None,
    tags: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Registers a new domain.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is available as the resource of this action.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        name(str): Name of the domain to register. The name must be unique in the region that the domain is registered in. The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        description(str, optional): A text description of the domain. Defaults to None.
        workflow_execution_retention_period_in_days(str): The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls. If you pass the value NONE or 0 (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted. The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: Amazon SWF Service Limits in the Amazon SWF Developer Guide.
        tags(List, optional): Tags to be added when registering a domain. Tags may only contain unicode letters, digits, whitespace, or these symbols: _ . : / = + - @. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.domain.register(
                ctx, name=value, workflow_execution_retention_period_in_days=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.domain.register name=value, workflow_execution_retention_period_in_days=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="register_domain",
        op_kwargs={
            "name": name,
            "description": description,
            "workflowExecutionRetentionPeriodInDays": workflow_execution_retention_period_in_days,
            "tags": tags,
        },
    )


async def undeprecate(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new workflow executions or register new types.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        name(str): The name of the domain of the deprecated workflow type.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.domain.undeprecate(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.domain.undeprecate name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="undeprecate_domain",
        op_kwargs={"name": name},
    )
