"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def respond(
    hub, ctx, task_token: str, decisions: List = None, execution_context: str = None
) -> None:
    r"""
    **Autogenerated function**

    Used by deciders to tell the service that the DecisionTask identified by the taskToken has successfully completed. The decisions argument specifies the list of decisions made while processing the task. A DecisionTaskCompleted event is added to the workflow history. The executionContext specified is attached to the event in the workflow execution history.  Access Control  If an IAM policy grants permission to use RespondDecisionTaskCompleted, it can express permissions for the list of decisions in the decisions parameter. Each of the decisions has one or more parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For more information, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        task_token(str): The taskToken from the DecisionTask.   taskToken is generated by the service and should be treated as an opaque value. If the task is passed to another process, its taskToken must also be passed. This enables it to provide its progress and respond with results. .
        decisions(List, optional): The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the Decision structure for details. Defaults to None.
        execution_context(str, optional): User defined context to add to workflow execution. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.decision_task_completed.respond(ctx, task_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.decision_task_completed.respond task_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="respond_decision_task_completed",
        op_kwargs={
            "taskToken": task_token,
            "decisions": decisions,
            "executionContext": execution_context,
        },
    )
