"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def request(hub, ctx, domain: str, workflow_id: str, run_id: str = None) -> None:
    r"""
    **Autogenerated function**

    Records a WorkflowExecutionCancelRequested event in the currently running workflow execution identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history with this event.  If the runId isn't specified, the WorkflowExecutionCancelRequested event is recorded in the history of the current open workflow execution with the specified workflowId in the domain.   Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of TerminateWorkflowExecution when possible.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain containing the workflow execution to cancel.
        workflow_id(str): The workflowId of the workflow execution to cancel.
        run_id(str, optional): The runId of the workflow execution to cancel. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.cancel_workflow_execution.request(
                ctx, domain=value, workflow_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.cancel_workflow_execution.request domain=value, workflow_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="request_cancel_workflow_execution",
        op_kwargs={"domain": domain, "workflowId": workflow_id, "runId": run_id},
    )
