"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def deprecate(hub, ctx, domain: str, activity_type: Dict) -> None:
    r"""
    **Autogenerated function**

    Deprecates the specified activity type. After an activity type has been deprecated, you cannot create new tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to run.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    activityType.name: String constraint. The key is swf:activityType.name.    activityType.version: String constraint. The key is swf:activityType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the activity type is registered.
        activity_type(Dict): The activity type to deprecate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.activity.type_.deprecate(
                ctx, domain=value, activity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.activity.type.deprecate domain=value, activity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="deprecate_activity_type",
        op_kwargs={"domain": domain, "activityType": activity_type},
    )


async def describe(hub, ctx, domain: str, activity_type: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified activity type. This includes configuration settings provided when the type was registered and other general information about the type.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    activityType.name: String constraint. The key is swf:activityType.name.    activityType.version: String constraint. The key is swf:activityType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the activity type is registered.
        activity_type(Dict): The activity type to get information about. Activity types are identified by the name and version that were supplied when the activity was registered.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.activity.type_.describe(
                ctx, domain=value, activity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.activity.type.describe domain=value, activity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="describe_activity_type",
        op_kwargs={"domain": domain, "activityType": activity_type},
    )


async def list_all(
    hub,
    ctx,
    domain: str,
    registration_status: str,
    name: str = None,
    next_page_token: str = None,
    maximum_page_size: int = None,
    reverse_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all activities registered in the specified domain that match the specified name and registration status. The result includes information like creation date, current status of the activity, etc. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.  Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   You cannot use an IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which the activity types have been registered.
        name(str, optional): If specified, only lists the activity types that have this name. Defaults to None.
        registration_status(str): Specifies the registration status of the activity types to list.
        next_page_token(str, optional): If NextPageToken is returned there are more results available. The value of NextPageToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has exceeded its maximum lifetime".  The configured maximumPageSize determines how many results can be returned in a single call. . Defaults to None.
        maximum_page_size(int, optional): The maximum number of results that are returned per call. Use nextPageToken to obtain further pages of results. . Defaults to None.
        reverse_order(bool, optional): When set to true, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by name of the activity types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.activity.type_.list_all(
                ctx, domain=value, registration_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.activity.type.list_all domain=value, registration_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="list_activity_types",
        op_kwargs={
            "domain": domain,
            "name": name,
            "registrationStatus": registration_status,
            "nextPageToken": next_page_token,
            "maximumPageSize": maximum_page_size,
            "reverseOrder": reverse_order,
        },
    )


async def register(
    hub,
    ctx,
    domain: str,
    name: str,
    version: str,
    description: str = None,
    default_task_start_to_close_timeout: str = None,
    default_task_heartbeat_timeout: str = None,
    default_task_list: Dict = None,
    default_task_priority: str = None,
    default_task_schedule_to_start_timeout: str = None,
    default_task_schedule_to_close_timeout: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Registers a new activity type along with its configuration settings in the specified domain.  A TypeAlreadyExists fault is returned if the type already exists in the domain. You cannot change any configuration settings of the type after its registration, and it must be registered as a new version.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    defaultTaskList.name: String constraint. The key is swf:defaultTaskList.name.    name: String constraint. The key is swf:name.    version: String constraint. The key is swf:version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain in which this activity is to be registered.
        name(str): The name of the activity type within the domain. The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        version(str): The version of the activity type.  The activity type consists of the name and version, the combination of which must be unique within the domain.  The specified string must not start or end with whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not be the literal string arn.
        description(str, optional): A textual description of the activity type. Defaults to None.
        default_task_start_to_close_timeout(str, optional): If set, specifies the default maximum duration that a worker can take to process tasks of this activity type. This default can be overridden when scheduling an activity task using the ScheduleActivityTask Decision. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration. Defaults to None.
        default_task_heartbeat_timeout(str, optional): If set, specifies the default maximum time before which a worker processing a task of this type must report progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. This default can be overridden when scheduling an activity task using the ScheduleActivityTask Decision. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an UnknownResource fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration. Defaults to None.
        default_task_list(Dict, optional): If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list is used if a task list isn't provided when a task is scheduled through the ScheduleActivityTask Decision. Defaults to None.
        default_task_priority(str, optional): The default task priority to assign to the activity type. If not assigned, then 0 is used. Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For more information about setting task priority, see Setting Task Priority in the in the Amazon SWF Developer Guide.. Defaults to None.
        default_task_schedule_to_start_timeout(str, optional): If set, specifies the default maximum duration that a task of this activity type can wait before being assigned to a worker. This default can be overridden when scheduling an activity task using the ScheduleActivityTask Decision. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration. Defaults to None.
        default_task_schedule_to_close_timeout(str, optional): If set, specifies the default maximum duration for a task of this activity type. This default can be overridden when scheduling an activity task using the ScheduleActivityTask Decision. The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.activity.type_.register(
                ctx, domain=value, name=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.activity.type.register domain=value, name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="register_activity_type",
        op_kwargs={
            "domain": domain,
            "name": name,
            "version": version,
            "description": description,
            "defaultTaskStartToCloseTimeout": default_task_start_to_close_timeout,
            "defaultTaskHeartbeatTimeout": default_task_heartbeat_timeout,
            "defaultTaskList": default_task_list,
            "defaultTaskPriority": default_task_priority,
            "defaultTaskScheduleToStartTimeout": default_task_schedule_to_start_timeout,
            "defaultTaskScheduleToCloseTimeout": default_task_schedule_to_close_timeout,
        },
    )


async def undeprecate(hub, ctx, domain: str, activity_type: Dict) -> None:
    r"""
    **Autogenerated function**

    Undeprecates a previously deprecated activity type. After an activity type has been undeprecated, you can create new tasks of that activity type.  This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates and changes.   Access Control  You can use IAM policies to control this action's access to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the action to only specified domains.   Use an Action element to allow or deny permission to call this action.   Constrain the following parameters by using a Condition element with the appropriate keys.    activityType.name: String constraint. The key is swf:activityType.name.    activityType.version: String constraint. The key is swf:activityType.version.     If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

    Args:
        domain(str): The name of the domain of the deprecated activity type.
        activity_type(Dict): The activity type to undeprecate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.swf.activity.type_.undeprecate(
                ctx, domain=value, activity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.swf.activity.type.undeprecate domain=value, activity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="swf",
        operation="undeprecate_activity_type",
        op_kwargs={"domain": domain, "activityType": activity_type},
    )
