"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, check_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the results for the AWS Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation. The response contains an array of TrustedAdvisorCheckSummary objects.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        check_ids(List): The IDs of the Trusted Advisor checks.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.trusted_advisor_check.summary.describe_all(
                ctx, check_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.trusted_advisor_check.summary.describe_all check_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_trusted_advisor_check_summaries",
        op_kwargs={"checkIds": check_ids},
    )
