"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, check_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the refresh status of the AWS Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation. Some checks are refreshed automatically, and you can't return their refresh statuses by using the DescribeTrustedAdvisorCheckRefreshStatuses operation. If you call this operation for these checks, you might see an InvalidParameterValue error.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        check_ids(List): The IDs of the Trusted Advisor checks to get the status.  If you specify the check ID of a check that is automatically refreshed, you might see an InvalidParameterValue error. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.trusted_advisor_check.refresh_status.describe_all(
                ctx, check_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.trusted_advisor_check.refresh_status.describe_all check_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_trusted_advisor_check_refresh_statuses",
        op_kwargs={"checkIds": check_ids},
    )
