"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, language: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all available AWS Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code. The AWS Support API currently supports English ("en") and Japanese ("ja"). The response contains a TrustedAdvisorCheckDescription object for each check. You must set the AWS Region to us-east-1.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.   The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.

    Args:
        language(str): The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.trusted_advisor_check.init.describe_all(
                ctx, language=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.trusted_advisor_check.init.describe_all language=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_trusted_advisor_checks",
        op_kwargs={"language": language},
    )


async def refresh(hub, ctx, check_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Refreshes the AWS Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.  Some checks are refreshed automatically. If you call the RefreshTrustedAdvisorCheck operation to refresh them, you might see the InvalidParameterValue error.  The response contains a TrustedAdvisorCheckRefreshStatus object.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        check_id(str): The unique identifier for the Trusted Advisor check to refresh.  Specifying the check ID of a check that is automatically refreshed causes an InvalidParameterValue error. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.trusted_advisor_check.init.refresh(ctx, check_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.trusted_advisor_check.init.refresh check_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="refresh_trusted_advisor_check",
        op_kwargs={"checkId": check_id},
    )
