"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the CaseDetails data type that you include for a CreateCase request.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        language(str, optional): The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.severity_level.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.severity_level.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_severity_levels",
        op_kwargs={"language": language},
    )
