"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, service_code_list: List = None, language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current list of AWS services and a list of service categories for each service. You then use service names and categories in your CreateCase requests. Each AWS service has its own set of categories. The service codes and category codes correspond to the values that appear in the Service and Category lists on the AWS Support Center Create Case page. The values in those fields don't necessarily match the service codes and categories returned by the DescribeServices operation. Always use the service codes and categories that the DescribeServices operation returns, so that you have the most recent set of service and category codes.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        service_code_list(List, optional): A JSON-formatted list of service codes available for AWS services. Defaults to None.
        language(str, optional): The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.service.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.service.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_services",
        op_kwargs={"serviceCodeList": service_code_list, "language": language},
    )
