"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(
    hub,
    ctx,
    communication_body: str,
    case_id: str = None,
    cc_email_addresses: List = None,
    attachment_set_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds additional customer communication to an AWS Support case. Use the caseId parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the ccEmailAddresses parameter. The communicationBody value contains the text of the communication.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        case_id(str, optional): The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47 . Defaults to None.
        communication_body(str): The body of an email communication to add to the support case.
        cc_email_addresses(List, optional): The email addresses in the CC line of an email to be added to the support case. Defaults to None.
        attachment_set_id(str, optional): The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling AddAttachmentsToSet . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.communication.to_case.add(ctx, communication_body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.communication.to_case.add communication_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="add_communication_to_case",
        op_kwargs={
            "caseId": case_id,
            "communicationBody": communication_body,
            "ccEmailAddresses": cc_email_addresses,
            "attachmentSetId": attachment_set_id,
        },
    )
