"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    case_id: str,
    before_time: str = None,
    after_time: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns communications and attachments for one or more support cases. Use the afterTime and beforeTime parameters to filter by date. You can use the caseId parameter to restrict the results to a specific case. Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error. You can use the maxResults and nextToken parameters to control the pagination of the results. Set maxResults to the number of cases that you want to display on each page, and use nextToken to specify the resumption of pagination.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        case_id(str): The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47 .
        before_time(str, optional): The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation. Defaults to None.
        after_time(str, optional): The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation. Defaults to None.
        next_token(str, optional): A resumption point for pagination. Defaults to None.
        max_results(int, optional): The maximum number of results to return before paginating. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.communication.init.describe_all(ctx, case_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.communication.init.describe_all case_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_communications",
        op_kwargs={
            "caseId": case_id,
            "beforeTime": before_time,
            "afterTime": after_time,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
