"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subject: str,
    communication_body: str,
    service_code: str = None,
    severity_code: str = None,
    category_code: str = None,
    cc_email_addresses: List = None,
    language: str = None,
    issue_type: str = None,
    attachment_set_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a case in the AWS Support Center. This operation is similar to how you create a case in the AWS Support Center Create Case page. The AWS Support API doesn't support requesting service limit increases. You can submit a service limit increase in the following ways:    Submit a request from the AWS Support Center Create Case page.   Use the Service Quotas RequestServiceQuotaIncrease operation.   A successful CreateCase request returns an AWS Support case number. You can use the DescribeCases operation and specify the case number to get existing AWS Support cases. After you create a case, use the AddCommunicationToCase operation to add additional communication or attachments to an existing case. The caseId is separate from the displayId that appears in the AWS Support Center. Use the DescribeCases operation to get the displayId.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        subject(str): The title of the support case. The title appears in the Subject field on the AWS Support Center Create Case page.
        service_code(str, optional): The code for the AWS service. You can use the DescribeServices operation to get the possible serviceCode values. Defaults to None.
        severity_code(str, optional): A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with AWS Support. You can use the DescribeSeverityLevels operation to get the possible values for severityCode.  For more information, see SeverityLevel and Choosing a Severity in the AWS Support User Guide.  The availability of severity levels depends on the support plan for the AWS account. . Defaults to None.
        category_code(str, optional): The category of problem for the support case. You also use the DescribeServices operation to get the category code for a service. Each AWS service defines its own set of category codes. Defaults to None.
        communication_body(str): The communication body text that describes the issue. This text appears in the Description field on the AWS Support Center Create Case page.
        cc_email_addresses(List, optional): A list of email addresses that AWS Support copies on case correspondence. AWS Support identifies the account that creates the case when you specify your AWS credentials in an HTTP POST method or use the AWS SDKs. . Defaults to None.
        language(str, optional): The language in which AWS Support handles the case. You must specify the ISO 639-1 code for the language parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported. Defaults to None.
        issue_type(str, optional): The type of issue for the case. You can specify customer-service or technical. If you don't specify a value, the default is technical. Defaults to None.
        attachment_set_id(str, optional): The ID of a set of one or more attachments for the case. Create the set by using the AddAttachmentsToSet operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.case.create(
                ctx, subject=value, communication_body=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.case.create subject=value, communication_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="create_case",
        op_kwargs={
            "subject": subject,
            "serviceCode": service_code,
            "severityCode": severity_code,
            "categoryCode": category_code,
            "communicationBody": communication_body,
            "ccEmailAddresses": cc_email_addresses,
            "language": language,
            "issueType": issue_type,
            "attachmentSetId": attachment_set_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    case_id_list: List = None,
    display_id: str = None,
    after_time: str = None,
    before_time: str = None,
    include_resolved_cases: bool = None,
    next_token: str = None,
    max_results: int = None,
    language: str = None,
    include_communications: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of cases that you specify by passing one or more case IDs. You can use the afterTime and beforeTime parameters to filter the cases by date. You can set values for the includeResolvedCases and includeCommunications parameters to specify how much information to return. The response returns the following in JSON format:   One or more CaseDetails data types.   One or more nextToken values, which specify where to paginate the returned records represented by the CaseDetails objects.   Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        case_id_list(List, optional): A list of ID numbers of the support cases you want returned. The maximum number of cases is 100. Defaults to None.
        display_id(str, optional): The ID displayed for a case in the AWS Support Center user interface. Defaults to None.
        after_time(str, optional): The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation. Defaults to None.
        before_time(str, optional): The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation. Defaults to None.
        include_resolved_cases(bool, optional): Specifies whether to include resolved support cases in the DescribeCases response. By default, resolved cases aren't included. Defaults to None.
        next_token(str, optional): A resumption point for pagination. Defaults to None.
        max_results(int, optional): The maximum number of results to return before paginating. Defaults to None.
        language(str, optional): The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them. Defaults to None.
        include_communications(bool, optional): Specifies whether to include communications in the DescribeCases response. By default, communications are included. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.case.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.case.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_cases",
        op_kwargs={
            "caseIdList": case_id_list,
            "displayId": display_id,
            "afterTime": after_time,
            "beforeTime": before_time,
            "includeResolvedCases": include_resolved_cases,
            "nextToken": next_token,
            "maxResults": max_results,
            "language": language,
            "includeCommunications": include_communications,
        },
    )


async def resolve(hub, ctx, case_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Resolves a support case. This operation takes a caseId and returns the initial and final state of the case.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        case_id(str, optional): The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47 . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.case.resolve(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.case.resolve
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="resolve_case",
        op_kwargs={"caseId": case_id},
    )
