"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "to_set"


async def add(hub, ctx, attachments: List, attachment_set_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more attachments to an attachment set.  An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it's created. The expiryTime returned in the response is when the set expires.     You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        attachment_set_id(str, optional): The ID of the attachment set. If an attachmentSetId is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an attachmentSetId is specified, the attachments are added to the specified set, if it exists. Defaults to None.
        attachments(List): One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment. In the Attachment object, use the data parameter to specify the contents of the attachment file. In the previous request syntax, the value for data appear as blob, which is represented as a base64-encoded string. The value for fileName is the name of the attachment, such as troubleshoot-screenshot.png.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.attachment.to_set_.add(ctx, attachments=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.attachment.to_set.add attachments=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="add_attachments_to_set",
        op_kwargs={"attachmentSetId": attachment_set_id, "attachments": attachments},
    )
