"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, attachment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the AttachmentDetails objects that are returned by the DescribeCommunications operation.    You must have a Business or Enterprise Support plan to use the AWS Support API.    If you call the AWS Support API from an account that does not have a Business or Enterprise Support plan, the SubscriptionRequiredException error message appears. For information about changing your support plan, see AWS Support.

    Args:
        attachment_id(str): The ID of the attachment to return. Attachment IDs are returned by the DescribeCommunications operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.support.attachment.init.describe(ctx, attachment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.support.attachment.init.describe attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="support",
        operation="describe_attachment",
        op_kwargs={"attachmentId": attachment_id},
    )
